/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import java.util.Arrays;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropSortedIntChannel
extends Propagator<Variable> {
    private final SetVar set;
    private final IntVar[] ints;
    private final int nullValue;
    private final int offset;

    public PropSortedIntChannel(SetVar set, IntVar[] ints, int nullValue, int offset) {
        super(ArrayUtils.append({set}, ints), (Priority)PropagatorPriority.LINEAR, false);
        this.set = set;
        this.ints = ints;
        this.nullValue = nullValue;
        this.offset = offset;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        for (int i2 = this.set.getUB().size(); i2 < this.ints.length; ++i2) {
            this.ints[i2].instantiateTo(this.nullValue, (ICause)this);
        }
        int[] sortedLB = this.set.getLB().toArray();
        Arrays.sort(sortedLB);
        for (i = 0; i < sortedLB.length && i < this.ints.length; ++i) {
            this.ints[i].instantiateTo(sortedLB[i] + this.offset, (ICause)this);
        }
        if (sortedLB.length < this.set.getUB().size()) {
            for (i = sortedLB.length; i < this.set.getUB().size() && i < this.ints.length; ++i) {
                for (int k = 0; k < sortedLB.length; ++k) {
                    if (sortedLB[k] == this.nullValue) continue;
                    this.ints[i].removeValue(sortedLB[k], (ICause)this);
                }
            }
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int[] sortedValues = this.set.getValue().toArray();
            Arrays.sort(sortedValues);
            for (int i = 0; i < this.ints.length; ++i) {
                if (i < sortedValues.length && this.ints[i].getValue() != sortedValues[i] + this.offset) {
                    return ESat.FALSE;
                }
                if (i < sortedValues.length || this.ints[i].getValue() == this.nullValue) continue;
                return ESat.FALSE;
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

