/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import main.HapAlleleProbs;
import vcf.Marker;
import vcf.Markers;

public class LowMemHapAlleleProbs
implements HapAlleleProbs {
    private static final int N_BINS = 256;
    private static final int SHIFT = 128;
    private static final float INCREMENT = 0.00390625f;
    private final Markers markers;
    private final Samples samples;
    private final int hap;
    private final byte[] alleleBin;

    public LowMemHapAlleleProbs(Markers markers, Samples samples, int n, float[] fArray) {
        if (fArray.length != markers.sumAlleles()) {
            throw new IllegalArgumentException("inconsistent data");
        }
        if (n < 0 || n >= 2 * samples.nSamples()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        byte[] byArray = new byte[fArray.length - markers.nMarkers()];
        int n2 = 0;
        int n3 = markers.nMarkers();
        for (int i = 0; i < n3; ++i) {
            int n4;
            float f = 0.0f;
            int n5 = markers.sumAlleles(i);
            int n6 = markers.sumAlleles(i + 1);
            for (n4 = n5; n4 < n6; ++n4) {
                float f2 = fArray[n4];
                if (f2 < 0.0f || f2 > 1.05f || Float.isNaN(f2)) {
                    throw new IllegalArgumentException(String.valueOf(f2));
                }
                f += fArray[n4];
            }
            for (n4 = n5; n4 < n6 - 1; ++n4) {
                byArray[n2++] = LowMemHapAlleleProbs.convertToByte(fArray[n4] / f);
            }
        }
        assert (n2 == byArray.length);
        this.markers = markers;
        this.samples = samples;
        this.hap = n;
        this.alleleBin = byArray;
    }

    private static byte convertToByte(float f) {
        if (f >= 1.0f) {
            f = 0.99999f;
        }
        int n = (int)Math.floor(f * 256.0f) - 128;
        return (byte)n;
    }

    private static float convertToFloat(byte by) {
        return ((float)by + 128.5f) * 0.00390625f;
    }

    @Override
    public float allele(int n, int n2) {
        int n3 = this.markers.marker(n).nAlleles();
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException(String.valueOf(n2));
        }
        int n4 = this.markers.sumAlleles(n) - n;
        if (n3 == 2) {
            float f = LowMemHapAlleleProbs.convertToFloat(this.alleleBin[n4]);
            return n2 == 0 ? f : 1.0f - f;
        }
        if (n2 == n3 - 1) {
            return this.lastAlleleProb(n);
        }
        return LowMemHapAlleleProbs.convertToFloat(this.alleleBin[n4 + n2]);
    }

    private float lastAlleleProb(int n) {
        int n2 = this.markers.marker(n).nAlleles();
        int n3 = this.markers.sumAlleles(n) - n;
        int n4 = n3 + n2 - 1;
        float f = 1.0f;
        for (int i = n3; i < n4; ++i) {
            f -= LowMemHapAlleleProbs.convertToFloat(this.alleleBin[i]);
        }
        return f < 0.0f ? 0.0f : f;
    }

    @Override
    public int alleleWithMaxProb(int n) {
        int n2 = this.markers.marker(n).nAlleles();
        int n3 = this.markers.sumAlleles(n) - n;
        if (n2 == 2) {
            return this.alleleBin[n3] >= 0 ? 0 : 1;
        }
        int n4 = n3;
        int n5 = n3 + n2 - 1;
        float f = 0.0f;
        for (int i = n3; i < n5; ++i) {
            f += LowMemHapAlleleProbs.convertToFloat(this.alleleBin[i]);
            if (this.alleleBin[i] <= this.alleleBin[n4]) continue;
            n4 = i;
        }
        if (f < 0.5f) {
            return n2 - 1;
        }
        return n4 - n3;
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public int hapIndex() {
        return this.hap;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append('[');
        stringBuilder.append(this.getClass().toString());
        stringBuilder.append(": hap=");
        stringBuilder.append(this.hap);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

