/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Stack;

public final class QuickSort {
    private static final Comparator NATURAL_ORDER = new Comparator(){

        public int compare(Object l, Object r) {
            return ((Comparable)l).compareTo(r);
        }
    };

    private QuickSort() {
    }

    public static <T extends Comparable<? super T>> void sort(List<T> list) {
        QuickSort.sort(list, QuickSort.naturalOrder());
    }

    public static <T> void sort(List<T> list, Comparator<? super T> comparator) {
        if (list instanceof RandomAccess) {
            QuickSort.quicksort(list, comparator);
        } else {
            ArrayList<T> copy = new ArrayList<T>(list);
            QuickSort.quicksort(copy, comparator);
            list.clear();
            list.addAll(copy);
        }
    }

    private static <T> void quicksort(List<T> list, Comparator<? super T> cmp) {
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(0);
        stack.push(list.size());
        while (!stack.isEmpty()) {
            int left;
            int right = (Integer)stack.pop();
            if (right - (left = ((Integer)stack.pop()).intValue()) < 2) continue;
            int p = left + (right - left) / 2;
            p = QuickSort.partition(list, cmp, p, left, right);
            stack.push(p + 1);
            stack.push(right);
            stack.push(left);
            stack.push(p);
        }
    }

    private static <T> int partition(List<T> list, Comparator<? super T> cmp, int p, int start, int end) {
        int l = start;
        int h = end - 2;
        T piv = list.get(p);
        QuickSort.swap(list, p, end - 1);
        while (l < h) {
            if (cmp.compare(list.get(l), piv) <= 0) {
                ++l;
                continue;
            }
            if (cmp.compare(piv, list.get(h)) <= 0) {
                --h;
                continue;
            }
            QuickSort.swap(list, l, h);
        }
        int idx = h;
        if (cmp.compare(list.get(h), piv) < 0) {
            ++idx;
        }
        QuickSort.swap(list, end - 1, idx);
        return idx;
    }

    private static <T> void swap(List<T> list, int i, int j) {
        T tmp = list.get(i);
        list.set(i, list.get(j));
        list.set(j, tmp);
    }

    private static <T extends Comparable<? super T>> Comparator<T> naturalOrder() {
        return NATURAL_ORDER;
    }
}

