/*
 * Decompiled with CFR 0.152.
 */
package com.github.lbfgs4j.liblbfgs;

public class Arithmetic {
    public static boolean fsigndiff(double x, double y) {
        return x * (y / Math.abs(y)) < 0.0;
    }

    public static void vecset(double[] x, double c, int n) {
        for (int i = 0; i < n; ++i) {
            x[i] = c;
        }
    }

    public static void veccpy(double[] y, double[] x, int n) {
        for (int i = 0; i < n; ++i) {
            y[i] = x[i];
        }
    }

    public static void vecncpy(double[] y, double[] x, int n) {
        for (int i = 0; i < n; ++i) {
            y[i] = -x[i];
        }
    }

    public static void vecadd(double[] y, double[] x, double c, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            y[n2] = y[n2] + c * x[i];
        }
    }

    public static void vecdiff(double[] z, double[] x, double[] y, int n) {
        for (int i = 0; i < n; ++i) {
            z[i] = x[i] - y[i];
        }
    }

    public static void vecscale(double[] y, double c, int n) {
        int i = 0;
        while (i < n) {
            int n2 = i++;
            y[n2] = y[n2] * c;
        }
    }

    public static void vecmul(double[] y, double[] x, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            y[n2] = y[n2] * x[i];
        }
    }

    public static double vecdot(double[] x, double[] y, int n) {
        double s = 0.0;
        for (int i = 0; i < n; ++i) {
            s += x[i] * y[i];
        }
        return s;
    }

    public static double vec2norm(double[] x, int n) {
        return Math.sqrt(Arithmetic.vecdot(x, x, n));
    }

    public static double vec2norminv(double[] x, int n) {
        return 1.0 / Arithmetic.vec2norm(x, n);
    }
}

