/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.distance;

import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.DataType;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.matrix.Matrix;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DistanceMatrix
extends Matrix.AbstractMatrix
implements TaxonList {
    public static final double MAX_DISTANCE = 1000.0;
    protected String id = null;
    protected DataType dataType = null;
    int dimension = 0;
    boolean distancesKnown;
    private double[][] distances = null;
    protected PatternList patterns = null;
    private TaxonList taxa = null;

    public DistanceMatrix() {
    }

    public DistanceMatrix(TaxonList taxonList) {
        this.taxa = taxonList;
        this.dimension = taxonList.getTaxonCount();
        this.distances = new double[this.dimension][this.dimension];
        this.distancesKnown = true;
    }

    public DistanceMatrix(PatternList patternList) {
        this.setPatterns(patternList);
    }

    public void setPatterns(PatternList patternList) {
        this.taxa = patternList;
        this.patterns = patternList;
        this.dimension = patternList.getTaxonCount();
        this.dataType = patternList.getDataType();
        this.distancesKnown = false;
    }

    @Override
    public int getRowCount() {
        return this.dimension;
    }

    @Override
    public int getColumnCount() {
        return this.dimension;
    }

    @Override
    public double getElement(int n, int n2) {
        if (!this.distancesKnown) {
            this.calculateDistances();
        }
        return this.distances[n][n2];
    }

    public void setElement(int n, int n2, double d) {
        if (!this.distancesKnown) {
            this.calculateDistances();
        }
        this.distances[n][n2] = d;
    }

    public void calculateDistances() {
        this.distances = new double[this.dimension][this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = i + 1; j < this.dimension; ++j) {
                this.distances[i][j] = this.calculatePairwiseDistance(i, j);
                this.distances[j][i] = this.distances[i][j];
            }
            this.distances[i][i] = 0.0;
        }
        this.distancesKnown = true;
    }

    protected double calculatePairwiseDistance(int n, int n2) {
        int n3 = this.patterns.getPatternCount();
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n3; ++i) {
            int[] nArray = this.patterns.getPattern(i);
            int n4 = nArray[n];
            int n5 = nArray[n2];
            double d3 = this.patterns.getPatternWeight(i);
            if (!this.dataType.isAmbiguousState(n4) && !this.dataType.isAmbiguousState(n5) && n4 != n5) {
                d += d3;
            }
            d2 += d3;
        }
        double d4 = d / d2;
        return d4;
    }

    public double getMeanDistance() {
        if (!this.distancesKnown) {
            this.calculateDistances();
        }
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                if (i == j) continue;
                d += this.distances[i][j];
                ++n;
            }
        }
        return d / (double)n;
    }

    public String toString() {
        try {
            double[] dArray = this.getUpperTriangle();
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(dArray[0]));
            for (int i = 1; i < dArray.length; ++i) {
                stringBuffer.append(", ").append(String.valueOf(dArray[i]));
            }
            return stringBuffer.toString();
        }
        catch (Matrix.NotSquareException notSquareException) {
            return notSquareException.toString();
        }
    }

    @Override
    public int getTaxonCount() {
        return this.taxa.getTaxonCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        return this.taxa.getTaxon(n);
    }

    @Override
    public String getTaxonId(int n) {
        return this.taxa.getTaxonId(n);
    }

    @Override
    public int getTaxonIndex(String string) {
        return this.taxa.getTaxonIndex(string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        return this.taxa.getTaxonIndex(taxon);
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    @Override
    public Iterator<Taxon> iterator() {
        return new Iterator<Taxon>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < DistanceMatrix.this.getTaxonCount() - 1;
            }

            @Override
            public Taxon next() {
                ++this.index;
                return DistanceMatrix.this.getTaxon(this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        return this.taxa.getTaxonAttribute(n, string);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }
}

