/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree.treemetrics;

import dr.evolution.io.Importer;
import dr.evolution.io.NewickImporter;
import dr.evolution.tree.Tree;
import dr.evolution.tree.treemetrics.BranchScoreMetric;
import dr.evolution.tree.treemetrics.CladeHeightMetric;
import dr.evolution.tree.treemetrics.KendallColijnPathDifferenceMetric;
import dr.evolution.tree.treemetrics.RobinsonFouldsMetric;
import dr.evolution.tree.treemetrics.RootedBranchScoreMetric;
import dr.evolution.tree.treemetrics.SteelPennyPathDifferenceMetric;
import java.io.IOException;

public class TestTreeMetrics {
    public static void main(String[] stringArray) {
        try {
            NewickImporter newickImporter = new NewickImporter("(('A':1.2,'B':0.8):0.5,('C':0.8,'D':1.0):1.1)");
            Tree tree = newickImporter.importNextTree();
            System.out.println("4-taxa tree 1: " + tree);
            newickImporter = new NewickImporter("((('A':0.8,'B':1.4):0.3,'C':0.7):0.9,'D':1.0)");
            Tree tree2 = newickImporter.importNextTree();
            System.out.println("4-taxa tree 2: " + tree2);
            System.out.println();
            System.out.println("Paired trees:");
            System.out.println("BranchScore = " + new BranchScoreMetric().getMetric(tree, tree2));
            System.out.println("CladeHeight = " + new CladeHeightMetric().getMetric(tree, tree2));
            System.out.println("Kendall-Colijn lambda (0.0) = " + new KendallColijnPathDifferenceMetric(0.0).getMetric(tree, tree2));
            System.out.println("Kendall-Colijn lambda (0.5) = " + new KendallColijnPathDifferenceMetric(0.5).getMetric(tree, tree2));
            System.out.println("Kendall-Colijn lambda (1.0) = " + new KendallColijnPathDifferenceMetric(1.0).getMetric(tree, tree2));
            System.out.println("RobinsonFoulds = " + new RobinsonFouldsMetric().getMetric(tree, tree2));
            System.out.println("RootedBranchScore = " + new RootedBranchScoreMetric().getMetric(tree, tree2));
            System.out.println("Steel-Penny = " + new SteelPennyPathDifferenceMetric().getMetric(tree, tree2));
            System.out.println();
            newickImporter = new NewickImporter("(((('A':0.6,'B':0.6):0.1,'C':0.5):0.4,'D':0.7):0.1,'E':1.3)");
            tree = newickImporter.importNextTree();
            System.out.println("5-taxa tree 1: " + tree);
            newickImporter = new NewickImporter("((('A':0.8,'B':1.4):0.1,'C':0.7):0.2,('D':1.0,'E':0.9):1.3)");
            tree2 = newickImporter.importNextTree();
            System.out.println("5-taxa tree 2: " + tree2);
            System.out.println();
            System.out.println("Paired trees:");
            System.out.println("BranchScore = " + new BranchScoreMetric().getMetric(tree, tree2));
            System.out.println("CladeHeight = " + new CladeHeightMetric().getMetric(tree, tree2));
            System.out.println("Kendall-Colijn lambda (0.0) = " + new KendallColijnPathDifferenceMetric(0.0).getMetric(tree, tree2));
            System.out.println("Kendall-Colijn lambda (0.5) = " + new KendallColijnPathDifferenceMetric(0.5).getMetric(tree, tree2));
            System.out.println("Kendall-Colijn lambda (1.0) = " + new KendallColijnPathDifferenceMetric(1.0).getMetric(tree, tree2));
            System.out.println("RobinsonFoulds = " + new RobinsonFouldsMetric().getMetric(tree, tree2));
            System.out.println("RootedBranchScore = " + new RootedBranchScoreMetric().getMetric(tree, tree2));
            System.out.println("Steel-Penny = " + new SteelPennyPathDifferenceMetric().getMetric(tree, tree2));
            System.out.println();
        }
        catch (Importer.ImportException importException) {
            System.err.println(importException);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }
}

