/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg.operators;

import dr.evomodel.arg.ARGModel;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public class ARGPartitioningOperator
extends SimpleMCMCOperator {
    private final CompoundParameter partitioningParameters;
    private final ARGModel arg;
    public static final String OPERATOR_NAME = "argPartitionOperator";
    public static final String TOSS_SIZE = "tossSize";
    public static final String TOSS_ALL = "tossAll";
    private final boolean tossAll;
    private final boolean isRecombination;
    private final int tossSize;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("weight"), AttributeRule.newIntegerRule("tossSize", true), AttributeRule.newBooleanRule("tossAll", true), new ElementRule(ARGModel.class)};

        @Override
        public String getParserName() {
            return ARGPartitioningOperator.OPERATOR_NAME;
        }

        @Override
        public String[] getParserNames() {
            return new String[]{ARGPartitioningOperator.OPERATOR_NAME, "tossPartitioningOperator"};
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n = xMLObject.getIntegerAttribute("weight");
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            int n2 = 1;
            if (xMLObject.hasAttribute(ARGPartitioningOperator.TOSS_SIZE) && ((n2 = xMLObject.getIntegerAttribute(ARGPartitioningOperator.TOSS_SIZE)) <= 0 || n2 >= aRGModel.getNumberOfPartitions())) {
                throw new XMLParseException("Toss size is incorrect");
            }
            boolean bl = false;
            if (xMLObject.hasAttribute(ARGPartitioningOperator.TOSS_ALL)) {
                bl = xMLObject.getBooleanAttribute(ARGPartitioningOperator.TOSS_ALL);
            }
            Logger.getLogger("dr.evomodel").info("Creating ARGPartitionOperator: tossSize=" + n2 + " " + ARGPartitioningOperator.TOSS_ALL + "=" + bl);
            return new ARGPartitioningOperator(aRGModel, n2, n, bl);
        }

        @Override
        public String getParserDescription() {
            return "An operator that picks a new partitioning uniformly at random.";
        }

        @Override
        public Class getReturnType() {
            return ARGPartitioningOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public ARGPartitioningOperator(ARGModel aRGModel, int n, int n2, boolean bl) {
        super.setWeight(n2);
        this.arg = aRGModel;
        this.partitioningParameters = aRGModel.getPartitioningParameters();
        this.tossSize = n;
        this.isRecombination = aRGModel.isRecombinationPartitionType();
        this.tossAll = bl;
    }

    @Override
    public Parameter getParameter() {
        return this.partitioningParameters;
    }

    @Override
    public final double doOperation() {
        double d = 0.0;
        int n = this.partitioningParameters.getParameterCount();
        if (n == 0) {
            return 0.0;
        }
        boolean[] blArray = new boolean[this.arg.getNumberOfPartitions()];
        if (this.tossAll) {
            for (int i = 0; i < n; ++i) {
                d += this.doFlip(i, blArray);
            }
        } else {
            d = this.doFlip(MathUtils.nextInt(n), blArray);
        }
        this.arg.fireModelChanged(new PartitionChangedEvent(this.partitioningParameters, blArray));
        return d;
    }

    private double doFlip(int n, boolean[] blArray) {
        if (this.isRecombination) {
            return this.doRecombination(this.partitioningParameters.getParameter(n), blArray);
        }
        return this.doReassortment(this.partitioningParameters.getParameter(n), blArray);
    }

    private double doRecombination(Parameter parameter, boolean[] blArray) {
        assert (ARGPartitioningOperator.checkValidRecombinationPartition(parameter));
        int n = 0;
        int n2 = this.arg.getNumberOfPartitions();
        for (int i = 0; i < n2; ++i) {
            if (parameter.getParameterValue(i) != 1.0) continue;
            n = i;
            break;
        }
        assert (n > 0);
        if (MathUtils.nextBoolean()) {
            parameter.setParameterValueQuietly(n, 0.0);
            blArray[n] = true;
        } else {
            parameter.setParameterValueQuietly(n - 1, 1.0);
            blArray[n - 1] = true;
        }
        if (!ARGPartitioningOperator.checkValidRecombinationPartition(parameter)) {
            return Double.NEGATIVE_INFINITY;
        }
        return 0.0;
    }

    public static boolean checkValidRecombinationPartition(Parameter parameter) {
        int n = parameter.getDimension();
        return parameter.getParameterValue(0) == 0.0 && parameter.getParameterValue(n - 1) == 1.0;
    }

    private double doReassortment(Parameter parameter, boolean[] blArray) {
        assert (ARGPartitioningOperator.checkValidReassortmentPartition(parameter));
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.tossSize);
        while (arrayList.size() < this.tossSize) {
            int n = MathUtils.nextInt(this.arg.getNumberOfPartitions() - 1) + 1;
            if (arrayList.contains(n)) continue;
            arrayList.add(n);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (parameter.getParameterValue(n) == 0.0) {
                parameter.setParameterValueQuietly(n, 1.0);
            } else {
                parameter.setParameterValueQuietly(n, 0.0);
            }
            blArray[n] = true;
        }
        if (!ARGPartitioningOperator.checkValidReassortmentPartition(parameter)) {
            return Double.NEGATIVE_INFINITY;
        }
        return 0.0;
    }

    public static boolean checkValidReassortmentPartition(Parameter parameter) {
        if (parameter.getParameterValue(0) != 0.0) {
            return false;
        }
        double[] dArray = parameter.getParameterValues();
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d != 0.0 && d != (double)dArray.length;
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    public String getPerformanceSuggestion() {
        return null;
    }

    public String toString() {
        return "tossPartitioningOperator(" + this.partitioningParameters.getParameterName() + ")";
    }

    public class PartitionChangedEvent {
        Parameter partitioning;
        boolean[] updatePartition;

        public PartitionChangedEvent(Parameter parameter, boolean[] blArray) {
            this.partitioning = parameter;
            this.updatePartition = blArray;
        }

        public Parameter getParameter() {
            return this.partitioning;
        }

        public boolean[] getUpdatedPartitions() {
            return this.updatePartition;
        }
    }
}

