/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.bigfasttree.thorney;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeStatistic;

public class SubtreeRootHeightStatistic
extends TreeStatistic {
    private ConstrainedTreeModel tree;
    private int dimension;
    private int subtree;
    private final double mostRecentTipTime;
    private final boolean isBackwards;

    public SubtreeRootHeightStatistic(String string, ConstrainedTreeModel constrainedTreeModel, TaxonList taxonList, boolean bl) {
        super(string);
        if (taxonList == null) {
            this.subtree = -1;
            this.dimension = constrainedTreeModel.getSubtreeCount();
        } else {
            int[] nArray = new int[taxonList.getTaxonCount()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = constrainedTreeModel.getExternalNode(constrainedTreeModel.getTaxonIndex(taxonList.getTaxon(i))).getNumber();
            }
            NodeRef nodeRef = TreeUtils.getCommonAncestor(constrainedTreeModel, nArray);
            this.subtree = constrainedTreeModel.getSubtreeIndex(nodeRef);
            this.dimension = 1;
        }
        if (bl && Taxon.getMostRecentDate() != null) {
            this.isBackwards = Taxon.getMostRecentDate().isBackwards();
            this.mostRecentTipTime = Taxon.getMostRecentDate().getAbsoluteTimeValue();
        } else {
            this.mostRecentTipTime = Double.NaN;
            this.isBackwards = false;
        }
        this.setTree(constrainedTreeModel);
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public double getStatisticValue(int n) {
        TreeModel treeModel = this.subtree == -1 ? this.tree.getSubtree(n) : this.tree.getSubtree(this.subtree);
        if (!Double.isNaN(this.mostRecentTipTime)) {
            if (this.isBackwards) {
                return this.mostRecentTipTime + treeModel.getNodeHeight(treeModel.getRoot());
            }
            return this.mostRecentTipTime - treeModel.getNodeHeight(treeModel.getRoot());
        }
        return treeModel.getNodeHeight(treeModel.getRoot());
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = (ConstrainedTreeModel)tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }
}

