/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evomodel.coalescent.CoalescentTreeIntervalStatistic;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;

public class ExponentialProductLikelihood
extends Likelihood.Abstract {
    private TreeModel treeModel;
    private double logPopSize;

    public ExponentialProductLikelihood(TreeModel treeModel, double d) {
        super(treeModel);
        this.treeModel = treeModel;
        this.logPopSize = d;
    }

    @Override
    public double calculateLogLikelihood() {
        double d = 0.0;
        CoalescentTreeIntervalStatistic coalescentTreeIntervalStatistic = new CoalescentTreeIntervalStatistic(this.treeModel);
        for (int i = 0; i < coalescentTreeIntervalStatistic.getDimension(); ++i) {
            double d2;
            int n = (int)coalescentTreeIntervalStatistic.getLineageCount(i) * ((int)coalescentTreeIntervalStatistic.getLineageCount(i) - 1) / 2;
            double d3 = coalescentTreeIntervalStatistic.getStatisticValue(i);
            if (coalescentTreeIntervalStatistic.getLineageCount(i) == 1.0) continue;
            if (i == coalescentTreeIntervalStatistic.getDimension() - 1) {
                d2 = -this.logPopSize - (double)n * d3 * Math.exp(-this.logPopSize);
                d += d2;
                continue;
            }
            if (coalescentTreeIntervalStatistic.getLineageCount(i) > coalescentTreeIntervalStatistic.getLineageCount(i + 1)) {
                d2 = -this.logPopSize - (double)n * d3 * Math.exp(-this.logPopSize);
                d += d2;
                continue;
            }
            d2 = (double)(-n) * d3 * Math.exp(-this.logPopSize);
            d += d2;
        }
        return d;
    }

    @Override
    protected boolean getLikelihoodKnown() {
        return false;
    }
}

