/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evomodel.treedatalikelihood.TipStateAccessor;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;

public class TipStateSwapOperator
extends SimpleMCMCOperator {
    public static final String TIP_STATE_OPERATOR = "tipStateSwapOperator";
    private final int[] states1;
    private final int[] states2;
    private int index1;
    private int index2;
    private final TipStateAccessor treeLikelihood;
    private final boolean uniformRandomization;

    public TipStateSwapOperator(TipStateAccessor tipStateAccessor, double d, boolean bl) {
        this.treeLikelihood = tipStateAccessor;
        this.setWeight(d);
        this.uniformRandomization = bl;
        int n = tipStateAccessor.getPatternCount();
        this.states1 = new int[n];
        this.states2 = new int[n];
    }

    @Override
    public double doOperation() {
        int n = this.treeLikelihood.getTipCount();
        this.index2 = this.index1 = MathUtils.nextInt(n);
        while (this.index2 == this.index1) {
            this.index2 = MathUtils.nextInt(n);
        }
        this.swap(this.index1, this.index2);
        this.treeLikelihood.makeDirty();
        return this.uniformRandomization ? Double.POSITIVE_INFINITY : 0.0;
    }

    private void swap(int n, int n2) {
        this.treeLikelihood.getTipStates(n, this.states1);
        this.treeLikelihood.getTipStates(n2, this.states2);
        this.treeLikelihood.setTipStates(n2, this.states1);
        this.treeLikelihood.setTipStates(n, this.states2);
    }

    @Override
    public void reject() {
        super.reject();
        this.swap(this.index1, this.index2);
    }

    @Override
    public String getOperatorName() {
        return TIP_STATE_OPERATOR;
    }
}

