/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evomodel.speciation.CalibratedSpeciationLikelihood;
import dr.evomodel.speciation.SpeciationLikelihood;
import dr.evomodel.speciation.SpeciationLikelihoodGradient;
import dr.evomodel.tree.TreeModel;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.xml.Reportable;

public class CalibratedSpeciationGradient
implements GradientWrtParameterProvider,
Reportable,
Loggable {
    private final SpeciationLikelihoodGradient speciationLikelihoodGradient;
    private final SpeciationLikelihood unCalibratedSpeciationLikelihood;
    private final CalibratedSpeciationLikelihood calibratedSpeciationLikelihood;
    private final TreeModel tree;

    public CalibratedSpeciationGradient(SpeciationLikelihoodGradient speciationLikelihoodGradient, CalibratedSpeciationLikelihood calibratedSpeciationLikelihood) {
        this.speciationLikelihoodGradient = speciationLikelihoodGradient;
        this.unCalibratedSpeciationLikelihood = (SpeciationLikelihood)speciationLikelihoodGradient.getLikelihood();
        this.calibratedSpeciationLikelihood = calibratedSpeciationLikelihood;
        this.tree = speciationLikelihoodGradient.getTree();
    }

    @Override
    public Likelihood getLikelihood() {
        return this.calibratedSpeciationLikelihood;
    }

    @Override
    public Parameter getParameter() {
        return this.speciationLikelihoodGradient.getParameter();
    }

    @Override
    public int getDimension() {
        return this.speciationLikelihoodGradient.getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        double[] dArray = this.speciationLikelihoodGradient.getGradientLogDensity();
        for (CalibratedSpeciationLikelihood.CalibrationLikelihood calibrationLikelihood : this.calibratedSpeciationLikelihood.getCalibrationLikelihoods()) {
            int n = calibrationLikelihood.getMrcaNodeNumber() - this.tree.getExternalNodeCount();
            double[] dArray2 = calibrationLikelihood.getGradientLogDensity();
            assert (dArray2.length == 1);
            int n2 = n;
            dArray[n2] = dArray[n2] + dArray2[0];
        }
        return dArray;
    }

    @Override
    public LogColumn[] getColumns() {
        return Loggable.getColumnsFromReport(this, "CalibratedSpeciationGradient report");
    }

    @Override
    public String getReport() {
        return GradientWrtParameterProvider.getReportAndCheckForError(this, 0.0, Double.POSITIVE_INFINITY, 0.01);
    }
}

