/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree.randomlocalmodel;

import dr.evolution.tree.NodeRef;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.randomlocalmodel.RandomLocalTreeVariable;
import dr.inference.loggers.LogFormatter;
import dr.inference.loggers.MCLogger;

public class RLTVLogger
extends MCLogger {
    private TreeModel treeModel;
    private RandomLocalTreeVariable randomLocal;

    public RLTVLogger(LogFormatter logFormatter, int n, TreeModel treeModel, RandomLocalTreeVariable randomLocalTreeVariable) {
        super(logFormatter, n, false);
        this.treeModel = treeModel;
        this.randomLocal = randomLocalTreeVariable;
    }

    @Override
    public void startLogging() {
        this.logLine("State\tRate changes");
    }

    @Override
    public void log(long l) {
        if (this.logEvery <= 0L || l % this.logEvery == 0L) {
            int n = this.treeModel.getNodeCount();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(l);
            for (int i = 0; i < n; ++i) {
                NodeRef nodeRef = this.treeModel.getNode(i);
                if (!this.randomLocal.isVariableSelected(this.treeModel, nodeRef)) continue;
                stringBuilder.append("\t");
                stringBuilder.append(nodeRef.getNumber());
                stringBuilder.append("\t");
                stringBuilder.append(this.randomLocal.getVariable(this.treeModel, nodeRef));
            }
            this.logLine(stringBuilder.toString());
        }
    }

    @Override
    public void stopLogging() {
        super.stopLogging();
    }
}

