/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treelikelihood;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.treelikelihood.AncestralStateTraitProvider;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class SplitBySiteTraitLogger
extends TreeTraitProvider.Helper
implements Citable {
    public static final String TRAIT_LOGGER = "splitTraitBySite";
    public static final String TRAIT_NAME = "traitName";
    public static final String SCALE = "scaleByBranchLength";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(AncestralStateTraitProvider.class, "The tree which is to be logged"), AttributeRule.newStringRule("traitName"), AttributeRule.newBooleanRule("scaleByBranchLength", true)};

        @Override
        public String getParserName() {
            return SplitBySiteTraitLogger.TRAIT_LOGGER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute(SplitBySiteTraitLogger.TRAIT_NAME);
            AncestralStateTraitProvider ancestralStateTraitProvider = (AncestralStateTraitProvider)xMLObject.getChild(AncestralStateTraitProvider.class);
            boolean bl = xMLObject.getAttribute(SplitBySiteTraitLogger.SCALE, false);
            return new SplitBySiteTraitLogger(ancestralStateTraitProvider, string, bl);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public String getExample() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return TreeTraitProvider.class;
        }
    };

    public SplitBySiteTraitLogger(final AncestralStateTraitProvider ancestralStateTraitProvider, String string, boolean bl) throws XMLParseException {
        int n;
        TreeTrait treeTrait = ancestralStateTraitProvider.getTreeTrait(string);
        if (treeTrait == null) {
            throw new XMLParseException("TreeTraitProvider does not provide trait named '" + string + ".");
        }
        MutableTreeModel mutableTreeModel = ancestralStateTraitProvider.getTreeModel();
        Object t = treeTrait.getTrait(mutableTreeModel, mutableTreeModel.getNode(0));
        boolean bl2 = false;
        boolean bl3 = false;
        if (t instanceof double[]) {
            n = ((double[])t).length;
            bl2 = true;
        } else if (t instanceof int[]) {
            n = ((int[])t).length;
            bl3 = true;
        } else {
            throw new XMLParseException("Unknown trait type to split");
        }
        TreeTrait[] treeTraitArray = new TreeTrait[n];
        if (bl2) {
            for (int i = 0; i < n; ++i) {
                treeTraitArray[i] = bl ? new TreeTrait.PickEntryDAndScale(treeTrait, i) : new TreeTrait.PickEntryD(treeTrait, i);
            }
        } else if (bl3) {
            for (int i = 0; i < n; ++i) {
                treeTraitArray[i] = string.compareTo("states") == 0 ? new TreeTrait.PickEntryI(treeTrait, i){

                    @Override
                    public String getTraitString(Tree tree, NodeRef nodeRef) {
                        int[] nArray = new int[]{this.getTrait(tree, nodeRef)};
                        return ancestralStateTraitProvider.formattedState(nArray);
                    }
                } : new TreeTrait.PickEntryI(treeTrait, i);
            }
        }
        this.addTraits(treeTraitArray);
        Logger.getLogger("dr.app.beagle").info("\tConstructing a split logger with " + n + " partitions;  please cite:\n" + Citable.Utils.getCitationString(this));
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.COUNTING_PROCESSES;
    }

    @Override
    public String getDescription() {
        return "Split by site trait logger";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.LEMEY_2012_RENAISSANCE);
    }
}

