/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.Patterns;
import dr.evolution.datatype.Microsatellite;
import dr.evolution.util.Taxa;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class MicrosatellitePatternParser
extends AbstractXMLObjectParser {
    public static final String MICROSATPATTERN = "microsatellitePattern";
    public static final String MICROSAT_SEQ = "microsatSeq";
    public static final String PRINT_DETAILS = "printDetails";
    public static final String PRINT_MSAT_PATTERN_CONTENT = "printMsatPatContent";
    public static final String ID = "id";
    public static final int COUNT_INCREMENT = 100;
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Taxa.class), new ElementRule(Microsatellite.class), new ElementRule("microsatSeq", new XMLSyntaxRule[]{new ElementRule(String.class, "A string of numbers representing the microsatellite lengths for a locus", "1,2,3,4,5,67,100")}, false), new StringAttributeRule("id", "the name of the locus"), AttributeRule.newBooleanRule("printDetails", true), AttributeRule.newBooleanRule("printMsatPatContent", true)};

    @Override
    public String getParserName() {
        return MICROSATPATTERN;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Taxa taxa = (Taxa)xMLObject.getChild(Taxa.class);
        Microsatellite microsatellite = (Microsatellite)xMLObject.getChild(Microsatellite.class);
        String[] stringArray = ((String)xMLObject.getElementFirstChild(MICROSAT_SEQ)).split(",");
        int[] nArray = new int[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = microsatellite.getState(stringArray[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLParseException("Unable to parse microsatellite data: " + numberFormatException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XMLParseException("Unable to parse microsatellite data: " + illegalArgumentException.getMessage());
        }
        Patterns patterns = new Patterns(microsatellite, taxa);
        patterns.addPattern(nArray);
        patterns.setId((String)xMLObject.getAttribute(ID));
        if (xMLObject.getAttribute(PRINT_DETAILS, true).booleanValue()) {
            MicrosatellitePatternParser.printDetails(patterns);
        }
        if (xMLObject.getAttribute(PRINT_MSAT_PATTERN_CONTENT, true).booleanValue()) {
            MicrosatellitePatternParser.printMicrosatContent(patterns);
        }
        return patterns;
    }

    public static void printDetails(Patterns patterns) {
        Logger.getLogger("dr.evoxml").info("    Locus name: " + patterns.getId() + "\n    Number of Taxa: " + patterns.getPattern(0).length + "\n    min: " + ((Microsatellite)patterns.getDataType()).getMin() + " max: " + ((Microsatellite)patterns.getDataType()).getMax() + "\n    state count: " + patterns.getDataType().getStateCount() + "\n");
    }

    public static void printMicrosatContent(Patterns patterns) {
        Logger.getLogger("dr.evoxml").info("    Locus name: " + patterns.getId());
        int[] nArray = patterns.getPattern(0);
        for (int i = 0; i < nArray.length; ++i) {
            Logger.getLogger("dr.evoxml").info("    Taxon: " + patterns.getTaxon(i) + " state: " + nArray[i]);
        }
        Logger.getLogger("dr.evoxml").info("\n");
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "This element represents a microsatellite pattern.";
    }

    @Override
    public Class getReturnType() {
        return Patterns.class;
    }
}

