/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.Reference;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;

public class FastMatrixParameter
extends CompoundParameter
implements MatrixParameterInterface {
    private static final String FAST_MATRIX_PARAMETER = "fastMatrixParameter";
    private static final String ROW_DIMENSION = "rows";
    private static final String COLUMN_DIMENSION = "columns";
    private static final String STARTING_VALUE = "startingValue";
    private static final String SIGNAL_COMPONENTS = "signalComponents";
    private List<String> proxyParameterNames;
    private final int rowDimension;
    private final int colDimension;
    private final Parameter singleParameter;
    private final boolean signalComponents;
    private List<ParameterProxy> proxyList = null;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Parameter.class, 0, Integer.MAX_VALUE), AttributeRule.newIntegerRule("rows", false), AttributeRule.newIntegerRule("columns", false), AttributeRule.newDoubleRule("startingValue", true), AttributeRule.newBooleanRule("signalComponents", true)};

        @Override
        public String getParserName() {
            return FastMatrixParameter.FAST_MATRIX_PARAMETER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.hasId() ? xMLObject.getId() : null;
            int n = xMLObject.getIntegerAttribute(FastMatrixParameter.ROW_DIMENSION);
            int n2 = xMLObject.getIntegerAttribute(FastMatrixParameter.COLUMN_DIMENSION);
            boolean bl = xMLObject.getAttribute(FastMatrixParameter.SIGNAL_COMPONENTS, false);
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                if (!(xMLObject.getChild(i) instanceof Parameter)) continue;
                arrayList.add((Parameter)xMLObject.getChild(i));
            }
            if (arrayList.size() > 0) {
                if (((Parameter)arrayList.get(0)).getDimension() != n || arrayList.size() != n2) {
                    throw new XMLParseException("Unable to cast matrixParameter to fastMatrixParameter");
                }
                FastMatrixParameter fastMatrixParameter = new FastMatrixParameter(string, arrayList, bl);
                this.replaceParameterReferences(xMLObject, fastMatrixParameter);
                return fastMatrixParameter;
            }
            double d = xMLObject.getAttribute(FastMatrixParameter.STARTING_VALUE, 1.0);
            return new FastMatrixParameter(string, n, n2, d, bl);
        }

        private void replaceParameterReferences(XMLObject xMLObject, FastMatrixParameter fastMatrixParameter) throws XMLParseException {
            int n;
            ArrayList<XMLObject> arrayList = new ArrayList<XMLObject>();
            for (n = 0; n < xMLObject.getChildCount(); ++n) {
                if (!(xMLObject.getChild(n) instanceof Parameter)) continue;
                Object object = xMLObject.getRawChild(n);
                if (object instanceof Reference) {
                    throw new XMLParseException("Currently can not use references in constructing a fast matrix parameter");
                }
                arrayList.add((XMLObject)xMLObject.getRawChild(n));
            }
            if (arrayList.size() != fastMatrixParameter.getColumnDimension()) {
                throw new XMLParseException("Invalid dimensions");
            }
            for (n = 0; n < arrayList.size(); ++n) {
                ((XMLObject)arrayList.get(n)).setNativeObject(fastMatrixParameter.getParameter(n));
            }
        }

        @Override
        public String getParserDescription() {
            return "A fast matrix parameter constructed from a single parameter.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return FastMatrixParameter.class;
        }
    };

    public FastMatrixParameter(String string, int n, int n2, double d) {
        this(string, n, n2, d, true);
    }

    public FastMatrixParameter(String string, int n, int n2, double d, boolean bl) {
        super(string);
        this.singleParameter = new Parameter.Default(n * n2);
        this.addParameter(this.singleParameter);
        for (int i = 0; i < this.singleParameter.getDimension(); ++i) {
            this.singleParameter.setParameterValue(i, d);
        }
        this.rowDimension = n;
        this.colDimension = n2;
        Parameter.DefaultBounds defaultBounds = new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, this.singleParameter.getDimension());
        this.addBounds(defaultBounds);
        this.signalComponents = bl;
    }

    public FastMatrixParameter(String string, List<Parameter> list, boolean bl) {
        this(string, list.get(0).getDimension(), list.size(), 0.0, bl);
        this.checkParameterLengths(list);
        this.setProxyParameterNames(list);
        for (int i = 0; i < this.rowDimension; ++i) {
            for (int j = 0; j < list.size(); ++j) {
                this.setParameterValueQuietly(i, j, list.get(j).getParameterValue(i));
            }
        }
        this.fireParameterChangedEvent(-1, Variable.ChangeType.ALL_VALUES_CHANGED);
    }

    @Override
    public String getDimensionName(int n) {
        int n2 = n / this.getRowDimension();
        int n3 = n % this.getRowDimension();
        String string = this.getParameter(n2).getParameterName() + (n3 + 1);
        return string;
    }

    private void checkParameterLengths(List<Parameter> list) {
        int n = list.get(0).getDimension();
        for (Parameter parameter : list) {
            if (parameter.getDimension() == n) continue;
            throw new RuntimeException("All columns must be the same length");
        }
    }

    private void setProxyParameterNames(List<Parameter> list) {
        this.proxyParameterNames = new ArrayList<String>(list.size());
        for (Parameter parameter : list) {
            this.proxyParameterNames.add(parameter.getParameterName());
        }
    }

    private void setProxyParameterName(String string, int n) {
        if (this.proxyParameterNames == null) {
            this.proxyParameterNames = new ArrayList<String>();
            for (int i = 0; i < this.getColumnDimension(); ++i) {
                this.proxyParameterNames.add(null);
            }
        }
        this.proxyParameterNames.set(n, string);
    }

    private String getProxyParameterName(int n) {
        return this.proxyParameterNames != null ? this.proxyParameterNames.get(n) : null;
    }

    @Override
    public Parameter getParameter(int n) {
        if (this.proxyList == null) {
            this.proxyList = new ArrayList<ParameterProxy>(this.colDimension);
            for (int i = 0; i < this.colDimension; ++i) {
                this.proxyList.add(new ParameterProxy(this, i));
            }
        }
        return this.proxyList.get(n);
    }

    @Override
    public void fireParameterChangedEvent() {
        if (this.signalComponents) {
            super.fireParameterChangedEvent();
        } else {
            this.fireParameterChangedEvent(-1, Variable.ChangeType.ALL_VALUES_CHANGED);
        }
    }

    @Override
    public double getParameterValue(int n, int n2) {
        return this.singleParameter.getParameterValue(this.index(n, n2));
    }

    @Override
    public double[] getParameterValues() {
        double[] dArray = new double[this.getDimension()];
        this.copyParameterValues(dArray, 0);
        return dArray;
    }

    @Override
    public void copyParameterValues(double[] dArray, int n) {
        double[] dArray2 = ((Parameter.Default)this.singleParameter).inspectParameterValues();
        System.arraycopy(dArray2, 0, dArray, n, dArray2.length);
    }

    @Override
    public void setAllParameterValuesQuietly(double[] dArray, int n) {
        double[] dArray2 = ((Parameter.Default)this.singleParameter).inspectParameterValues();
        System.arraycopy(dArray, n, dArray2, 0, dArray2.length);
    }

    @Override
    public String toSymmetricString() {
        return MatrixParameter.toSymmetricString(this);
    }

    @Override
    public boolean isConstrainedSymmetric() {
        return false;
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        this.singleParameter.setParameterValue(this.index(n, n2), d);
    }

    @Override
    public void setParameterValueQuietly(int n, int n2, double d) {
        this.singleParameter.setParameterValueQuietly(this.index(n, n2), d);
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, int n2, double d) {
        this.singleParameter.setParameterValueNotifyChangedAll(this.index(n, n2), d);
    }

    @Override
    public double[] getColumnValues(int n) {
        double[] dArray = new double[this.getRowDimension()];
        for (int i = 0; i < this.getRowDimension(); ++i) {
            dArray[i] = this.getParameterValue(i, n);
        }
        return dArray;
    }

    @Override
    public double[][] getParameterAsMatrix() {
        return MatrixParameterInterface.getParameterAsMatrix(this);
    }

    @Override
    public int getColumnDimension() {
        return this.colDimension;
    }

    @Override
    public int getRowDimension() {
        return this.rowDimension;
    }

    @Override
    public int getParameterCount() {
        return this.getColumnDimension();
    }

    @Override
    public int getUniqueParameterCount() {
        return 1;
    }

    @Override
    public Parameter getUniqueParameter(int n) {
        return super.getParameter(0);
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        this.singleParameter.addBounds(bounds);
    }

    @Override
    public Bounds<Double> getBounds() {
        return this.singleParameter.getBounds();
    }

    class ParameterProxy
    extends Parameter.Abstract {
        private final int column;
        private final FastMatrixParameter matrix;
        private Bounds<Double> bounds = null;

        ParameterProxy(FastMatrixParameter fastMatrixParameter2, int n) {
            this.matrix = fastMatrixParameter2;
            this.column = n;
        }

        @Override
        protected void storeValues() {
        }

        @Override
        protected void restoreValues() {
        }

        @Override
        protected void acceptValues() {
        }

        @Override
        protected void adoptValues(Parameter parameter) {
            throw new RuntimeException("Do not call");
        }

        @Override
        public double getParameterValue(int n) {
            return this.matrix.getParameterValue(n, this.column);
        }

        @Override
        public void setParameterValue(int n, double d) {
            this.matrix.setParameterValue(n, this.column, d);
            super.fireParameterChangedEvent(n, Variable.ChangeType.VALUE_CHANGED);
        }

        @Override
        public void setParameterValueQuietly(int n, double d) {
            this.matrix.setParameterValueQuietly(n, this.column, d);
        }

        @Override
        public void setParameterValueNotifyChangedAll(int n, double d) {
            throw new RuntimeException("Do not call");
        }

        @Override
        public void setId(String string) {
            this.matrix.setProxyParameterName(string, this.column);
        }

        @Override
        public String getParameterName() {
            String string = this.matrix.getProxyParameterName(this.column);
            return string != null ? string : this.getId();
        }

        @Override
        public void addBounds(Bounds<Double> bounds) {
            this.bounds = bounds;
        }

        @Override
        public Bounds<Double> getBounds() {
            return this.bounds;
        }

        @Override
        public void fireParameterChangedEvent(int n, Variable.ChangeType changeType) {
            this.matrix.fireParameterChangedEvent(n + this.column * this.getDimension(), changeType);
            super.fireParameterChangedEvent(n, Variable.ChangeType.VALUE_CHANGED);
        }

        @Override
        public void addDimension(int n, double d) {
            throw new RuntimeException("Do not call");
        }

        @Override
        public double removeDimension(int n) {
            throw new RuntimeException("Do not call");
        }

        @Override
        public int getDimension() {
            return this.matrix.getRowDimension();
        }
    }
}

