/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.Bounds;
import dr.inference.model.IntersectionBounds;
import dr.inference.model.VariableListener;
import dr.util.Identifiable;
import java.util.ArrayList;
import java.util.List;

public interface Variable<V>
extends Identifiable {
    public String getVariableName();

    public V getValue(int var1);

    public void setValue(int var1, V var2);

    public V[] getValues();

    public int getSize();

    public void addVariableListener(VariableListener var1);

    public void removeVariableListener(VariableListener var1);

    public void storeVariableValues();

    public void restoreVariableValues();

    public void acceptVariableValues();

    public Bounds<V> getBounds();

    public void addBounds(Bounds<V> var1);

    public static class I
    implements Variable<Integer>,
    Loggable {
        String id;
        int[] values;
        int[] storedValues;
        List<VariableListener> listeners = new ArrayList<VariableListener>();
        private Bounds<Integer> bounds = null;

        public I(int n, int n2) {
            this.values = new int[n2];
            this.storedValues = new int[this.values.length];
            for (int i = 0; i < n2; ++i) {
                this.values[i] = n;
            }
        }

        public I(int[] nArray) {
            this.values = new int[nArray.length];
            System.arraycopy(nArray, 0, this.values, 0, nArray.length);
            this.storedValues = new int[this.values.length];
        }

        public I(String string, int[] nArray) {
            this(nArray);
            this.setId(string);
        }

        public I(String string, int n) {
            this(string, new int[]{n});
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String string) {
            this.id = string;
        }

        @Override
        public String getVariableName() {
            return this.id;
        }

        @Override
        public Integer getValue(int n) {
            return this.values[n];
        }

        public Integer[] getValues() {
            Integer[] integerArray = new Integer[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                integerArray[i] = this.values[i];
            }
            return integerArray;
        }

        @Override
        public void setValue(int n, Integer n2) {
            this.values[n] = n2;
            this.fireVariableChanged(n);
        }

        private void fireVariableChanged(int n) {
            for (VariableListener variableListener : this.listeners) {
                variableListener.variableChangedEvent(this, n, ChangeType.VALUE_CHANGED);
            }
        }

        @Override
        public int getSize() {
            return this.values.length;
        }

        @Override
        public void addVariableListener(VariableListener variableListener) {
            this.listeners.add(variableListener);
        }

        @Override
        public void removeVariableListener(VariableListener variableListener) {
            this.listeners.remove(variableListener);
        }

        @Override
        public void storeVariableValues() {
            System.arraycopy(this.values, 0, this.storedValues, 0, this.storedValues.length);
        }

        @Override
        public void restoreVariableValues() {
            int[] nArray = this.storedValues;
            this.storedValues = this.values;
            this.values = nArray;
        }

        @Override
        public void acceptVariableValues() {
        }

        @Override
        public Bounds<Integer> getBounds() {
            if (this.bounds == null) {
                return new Bounds<Integer>(){

                    @Override
                    public Integer getUpperLimit(int n) {
                        return Integer.MAX_VALUE;
                    }

                    @Override
                    public Integer getLowerLimit(int n) {
                        return -2147483647;
                    }

                    @Override
                    public int getBoundsDimension() {
                        return this.getSize();
                    }
                };
            }
            return this.bounds;
        }

        @Override
        public LogColumn[] getColumns() {
            LogColumn[] logColumnArray = new LogColumn[this.getSize()];
            if (this.getSize() == 1) {
                logColumnArray[0] = new StatisticColumn(this.getVariableName(), 0);
            } else {
                for (int i = 0; i < this.getSize(); ++i) {
                    logColumnArray[i] = new StatisticColumn(this.getVariableName() + "[" + i + "]", i);
                }
            }
            return logColumnArray;
        }

        public int[] peekValues() {
            return this.values;
        }

        @Override
        public void addBounds(Bounds<Integer> bounds) {
            if (this.bounds == null) {
                this.bounds = bounds;
            } else {
                if (!(this.bounds instanceof Bounds.Staircase)) {
                    Bounds.Staircase staircase = new Bounds.Staircase(this.getSize());
                    staircase.addBounds(this.bounds);
                    this.bounds = staircase;
                }
                ((Bounds.Staircase)this.bounds).addBounds(bounds);
            }
        }

        private class StatisticColumn
        extends NumberColumn {
            private final int dim;

            public StatisticColumn(String string, int n) {
                super(string);
                this.dim = n;
            }

            @Override
            public double getDoubleValue() {
                return I.this.getValue(this.dim).intValue();
            }
        }
    }

    public static class DM
    implements Variable<double[]>,
    Loggable {
        String id;
        double[][] values;
        double[][] storedValues;
        List<VariableListener> listeners = new ArrayList<VariableListener>();
        double[] lower;
        double[] upper;

        public DM(double[][] dArray) {
            this.lower = new double[dArray.length];
            this.upper = new double[dArray.length];
            this.values = new double[dArray.length][dArray[0].length];
            for (int i = 0; i < dArray.length; ++i) {
                System.arraycopy(dArray[i], 0, this.values[i], 0, dArray[i].length);
                this.lower[i] = -1.7976931348623157E308;
                this.upper[i] = Double.MAX_VALUE;
            }
            this.storedValues = new double[this.values.length][this.values[0].length];
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String string) {
            this.id = string;
        }

        @Override
        public String getVariableName() {
            return this.id;
        }

        @Override
        public double[] getValue(int n) {
            return this.values[n];
        }

        public double[][] getValues() {
            double[][] dArray = new double[this.values.length][this.values[0].length];
            for (int i = 0; i < this.values.length; ++i) {
                System.arraycopy(this.values[i], 0, dArray[i], 0, this.values[i].length);
            }
            return dArray;
        }

        @Override
        public void setValue(int n, double[] dArray) {
            System.arraycopy(dArray, 0, this.values[n], 0, this.values[n].length);
            this.fireVariableChanged(n);
        }

        private void fireVariableChanged(int n) {
            for (VariableListener variableListener : this.listeners) {
                variableListener.variableChangedEvent(this, n, ChangeType.VALUE_CHANGED);
            }
        }

        @Override
        public int getSize() {
            return this.values.length;
        }

        @Override
        public void addVariableListener(VariableListener variableListener) {
            this.listeners.add(variableListener);
        }

        @Override
        public void removeVariableListener(VariableListener variableListener) {
            this.listeners.remove(variableListener);
        }

        @Override
        public void storeVariableValues() {
            for (int i = 0; i < this.values.length; ++i) {
                System.arraycopy(this.values[i], 0, this.storedValues[i], 0, this.storedValues[i].length);
            }
        }

        @Override
        public void restoreVariableValues() {
            double[][] dArray = this.storedValues;
            this.storedValues = this.values;
            this.values = dArray;
        }

        @Override
        public void acceptVariableValues() {
        }

        @Override
        public Bounds<double[]> getBounds() {
            return new Bounds<double[]>(){

                @Override
                public double[] getUpperLimit(int n) {
                    return upper;
                }

                @Override
                public double[] getLowerLimit(int n) {
                    return lower;
                }

                @Override
                public int getBoundsDimension() {
                    return this.getSize();
                }
            };
        }

        @Override
        public void addBounds(Bounds<double[]> bounds) {
        }

        @Override
        public LogColumn[] getColumns() {
            LogColumn[] logColumnArray = new LogColumn[this.getSize()];
            for (int i = 0; i < this.getSize(); ++i) {
                double[] dArray = this.getValue(i);
                for (int j = 0; j < dArray.length; ++j) {
                    logColumnArray[i] = this.getSize() == 1 ? new StatisticColumn(this.getVariableName() + "[" + j + "]", i, j) : new StatisticColumn(this.getVariableName() + "[" + i + "," + j + "]", i, j);
                }
            }
            return logColumnArray;
        }

        private class StatisticColumn
        extends NumberColumn {
            private final int i;
            private final int j;

            public StatisticColumn(String string, int n, int n2) {
                super(string);
                this.i = n;
                this.j = n2;
            }

            @Override
            public double getDoubleValue() {
                return DM.this.getValue(this.i)[this.j];
            }
        }
    }

    public static class D
    implements Variable<Double>,
    Loggable {
        String id;
        double[] values;
        double[] storedValues;
        List<VariableListener> listeners = new ArrayList<VariableListener>();
        private IntersectionBounds bounds = null;

        public D(double d, int n) {
            this.values = new double[n];
            this.storedValues = new double[this.values.length];
            for (int i = 0; i < n; ++i) {
                this.values[i] = d;
            }
        }

        public D(double[] dArray) {
            this.values = new double[dArray.length];
            System.arraycopy(dArray, 0, this.values, 0, dArray.length);
            this.storedValues = new double[this.values.length];
        }

        public D(String string, double[] dArray) {
            this(dArray);
            this.setId(string);
        }

        public D(String string, double d) {
            this(string, new double[]{d});
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String string) {
            this.id = string;
        }

        @Override
        public String getVariableName() {
            return this.id;
        }

        @Override
        public Double getValue(int n) {
            return this.values[n];
        }

        public Double[] getValues() {
            Double[] doubleArray = new Double[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                doubleArray[i] = this.values[i];
            }
            return doubleArray;
        }

        @Override
        public void setValue(int n, Double d) {
            this.values[n] = d;
            this.fireVariableChanged(n);
        }

        private void fireVariableChanged(int n) {
            for (VariableListener variableListener : this.listeners) {
                variableListener.variableChangedEvent(this, n, ChangeType.VALUE_CHANGED);
            }
        }

        @Override
        public int getSize() {
            return this.values.length;
        }

        @Override
        public void addVariableListener(VariableListener variableListener) {
            this.listeners.add(variableListener);
        }

        @Override
        public void removeVariableListener(VariableListener variableListener) {
            this.listeners.remove(variableListener);
        }

        @Override
        public void storeVariableValues() {
            System.arraycopy(this.values, 0, this.storedValues, 0, this.storedValues.length);
        }

        @Override
        public void restoreVariableValues() {
            double[] dArray = this.storedValues;
            this.storedValues = this.values;
            this.values = dArray;
        }

        @Override
        public void acceptVariableValues() {
        }

        @Override
        public Bounds<Double> getBounds() {
            if (this.bounds == null) {
                return new Bounds<Double>(){

                    @Override
                    public Double getUpperLimit(int n) {
                        return Double.MAX_VALUE;
                    }

                    @Override
                    public Double getLowerLimit(int n) {
                        return -1.7976931348623157E308;
                    }

                    @Override
                    public int getBoundsDimension() {
                        return this.getSize();
                    }
                };
            }
            return this.bounds;
        }

        @Override
        public LogColumn[] getColumns() {
            LogColumn[] logColumnArray = new LogColumn[this.getSize()];
            if (this.getSize() == 1) {
                logColumnArray[0] = new StatisticColumn(this.getVariableName(), 0);
            } else {
                for (int i = 0; i < this.getSize(); ++i) {
                    logColumnArray[i] = new StatisticColumn(this.getVariableName() + "[" + i + "]", i);
                }
            }
            return logColumnArray;
        }

        public double[] peekValues() {
            return this.values;
        }

        @Override
        public void addBounds(Bounds<Double> bounds) {
            if (this.bounds == null) {
                this.bounds = new IntersectionBounds(this.getSize());
            }
            this.bounds.addBounds(bounds);
        }

        private class StatisticColumn
        extends NumberColumn {
            private final int dim;

            public StatisticColumn(String string, int n) {
                super(string);
                this.dim = n;
            }

            @Override
            public double getDoubleValue() {
                return D.this.getValue(this.dim);
            }
        }
    }

    public static abstract class BaseNumerical<V extends Number>
    extends Base<V> {
        BaseNumerical(String string) {
            super(string);
        }

        @Override
        public LogColumn[] getColumns() {
            LogColumn[] logColumnArray = new LogColumn[this.getSize()];
            if (this.getSize() == 1) {
                logColumnArray[0] = new StatisticColumn(this.getVariableName(), 0);
            } else {
                for (int i = 0; i < this.getSize(); ++i) {
                    logColumnArray[i] = new StatisticColumn(this.getVariableName() + "[" + i + "]", i);
                }
            }
            return logColumnArray;
        }

        class StatisticColumn
        extends NumberColumn {
            private final int dim;

            public StatisticColumn(String string, int n) {
                super(string);
                this.dim = n;
            }

            @Override
            public double getDoubleValue() {
                return ((Number)BaseNumerical.this.getValue(this.dim)).doubleValue();
            }
        }
    }

    public static abstract class Base<V>
    implements Variable<V>,
    Loggable {
        protected List<VariableListener> listeners = new ArrayList<VariableListener>();
        protected String id;

        Base(String string) {
            this.id = string;
        }

        protected void fireVariableChanged(int n) {
            for (VariableListener variableListener : this.listeners) {
                variableListener.variableChangedEvent(this, n, ChangeType.VALUE_CHANGED);
            }
        }

        @Override
        public void addVariableListener(VariableListener variableListener) {
            this.listeners.add(variableListener);
        }

        @Override
        public void removeVariableListener(VariableListener variableListener) {
            this.listeners.remove(variableListener);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String string) {
            this.id = string;
        }

        @Override
        public String getVariableName() {
            return this.id;
        }
    }

    public static enum ChangeType {
        VALUE_CHANGED,
        REMOVED,
        ADDED,
        ALL_VALUES_CHANGED;

    }
}

