/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.GammaFunction;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import dr.math.distributions.GammaDistribution;

public class InverseGammaDistribution
implements Distribution {
    private double shape;
    private double scale;
    private final double factor;
    private final double logFacor;
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return InverseGammaDistribution.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };

    public InverseGammaDistribution(double d, double d2) {
        this.shape = d;
        this.scale = d2;
        this.factor = Math.pow(d2, d) / Math.exp(GammaFunction.lnGamma(d));
        this.logFacor = d * Math.log(d2) - GammaFunction.lnGamma(d);
    }

    public double getShape() {
        return this.shape;
    }

    public void setShape(double d) {
        this.shape = d;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    @Override
    public double pdf(double d) {
        return InverseGammaDistribution.pdf(d, this.shape, this.scale, this.factor);
    }

    @Override
    public double logPdf(double d) {
        return InverseGammaDistribution.logPdf(d, this.shape, this.scale, this.logFacor);
    }

    @Override
    public double cdf(double d) {
        return InverseGammaDistribution.cdf(d, this.shape, this.scale);
    }

    @Override
    public double quantile(double d) {
        return InverseGammaDistribution.quantile(d, this.shape, this.scale);
    }

    @Override
    public double mean() {
        return InverseGammaDistribution.mean(this.shape, this.scale);
    }

    @Override
    public double variance() {
        return InverseGammaDistribution.variance(this.shape, this.scale);
    }

    public double nextInverseGamma() {
        return InverseGammaDistribution.nextInverseGamma(this.shape, this.scale);
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double pdf(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d5 = Math.exp(d2 * Math.log(d3) - (d2 + 1.0) * Math.log(d) - d3 / d - GammaFunction.lnGamma(d2));
        return d4 * d5;
    }

    public static double logPdf(double d, double d2, double d3, double d4) {
        if (d <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return d4 + d2 * Math.log(d3) - (d2 + 1.0) * Math.log(d) - d3 / d - GammaFunction.lnGamma(d2);
    }

    public static double cdf(double d, double d2, double d3) {
        if (d <= 0.0 || d2 <= 0.0) {
            return 0.0;
        }
        return GammaFunction.incompleteGammaQ(d2, d3 / d);
    }

    public static double quantile(double d, double d2, double d3) {
        GammaDistribution gammaDistribution = new GammaDistribution(d2, d3);
        return 1.0 / gammaDistribution.quantile(1.0 - d);
    }

    public static double mean(double d, double d2) {
        if (d > 1.0) {
            return d2 / (d - 1.0);
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double variance(double d, double d2) {
        if (d > 2.0) {
            return d2 * d2 / ((d - 1.0) * (d2 - 1.0) * (d2 - 2.0));
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double nextInverseGamma(double d, double d2) {
        return 1.0 / new GammaDistribution(d, 1.0 / d2).nextGamma();
    }
}

