/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.temptable;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.aeprocessor.aetree.AESortSpec;
import com.amazon.sqlengine.executor.etree.ETCancelState;
import com.amazon.sqlengine.executor.etree.IMemManagerAgent;
import com.amazon.sqlengine.executor.etree.IMemoryConsumer;
import com.amazon.sqlengine.executor.etree.temptable.BlockConverter;
import com.amazon.sqlengine.executor.etree.temptable.DataStore;
import com.amazon.sqlengine.executor.etree.temptable.IRowView;
import com.amazon.sqlengine.executor.etree.temptable.OnePassSorter;
import com.amazon.sqlengine.executor.etree.temptable.RowBlock;
import com.amazon.sqlengine.executor.etree.temptable.RowComparator;
import com.amazon.sqlengine.executor.etree.temptable.TemporaryFile;
import com.amazon.sqlengine.executor.etree.temptable.TemporaryTableBuilder;
import com.amazon.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.amazon.support.ILogger;
import com.amazon.support.LogLevel;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.UUID;

public class Sorter
implements IMemoryConsumer {
    private OnePassSorter m_onePassSorter = null;
    private IColumn[] m_columnMeta;
    private RowComparator m_comparator;
    private TemporaryTableBuilder.TemporaryTableProperties m_properties;
    private RowComparator.NullCollation m_nullCollation;
    private ILogger m_logger;
    private boolean[] m_dataNeeded;
    private BlockConverter m_blockConverter;
    private long m_memAssigned = 0L;
    private IMemManagerAgent m_memAgent = null;
    private Stage m_currentStage;
    private final ETCancelState m_cancelState;

    public Sorter(List<IColumn> list, List<AESortSpec> list2, TemporaryTableBuilder.TemporaryTableProperties temporaryTableProperties, RowComparator.NullCollation nullCollation, ETCancelState eTCancelState, boolean[] blArray) throws ErrorException {
        this.m_properties = temporaryTableProperties;
        this.m_nullCollation = nullCollation;
        this.m_columnMeta = list.toArray(new IColumn[list.size()]);
        this.m_comparator = RowComparator.createComparator(this.m_columnMeta, list2, this.m_nullCollation);
        this.m_dataNeeded = (boolean[])blArray.clone();
        this.m_memAssigned = 0L;
        this.m_logger = this.m_properties.m_logger;
        this.m_blockConverter = new BlockConverter(this.m_columnMeta, this.m_properties, this.m_logger, blArray);
        this.m_currentStage = Stage.FIRST_PASS;
        this.m_cancelState = eTCancelState;
    }

    public void initialize() throws ErrorException {
        this.m_onePassSorter = new OnePassSorter(this.m_columnMeta, this.m_properties, this.m_comparator, this.m_dataNeeded);
        this.m_onePassSorter.increaseMemoryUsage(this.m_memAssigned);
    }

    public void addRow() throws ErrorException {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.appendRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStore getSorted(boolean bl) throws ErrorException {
        DataStore dataStore;
        List<DataStore> list;
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        try {
            list = this.m_onePassSorter.getSorted();
        }
        finally {
            this.m_onePassSorter.destroy();
            this.m_onePassSorter = null;
        }
        if (list.size() > 1) {
            this.m_currentStage = Stage.MERGING;
            dataStore = this.merge(list, bl);
        } else {
            dataStore = list.size() == 1 ? list.get(0) : null;
        }
        this.m_currentStage = Stage.FINISHED;
        this.m_blockConverter.reset();
        if (this.m_memAssigned != 0L && !bl) {
            this.m_memAgent.recycleMemory(this.m_memAssigned);
            this.m_memAssigned = 0L;
        }
        return dataStore;
    }

    public void finishAppending() {
        this.m_onePassSorter.finishAppending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private DataStore merge(List<DataStore> list, boolean bl) throws ErrorException {
        DataStore dataStore3;
        block24: {
            PriorityQueue<DataStore> priorityQueue = new PriorityQueue<DataStore>(list.size(), new Comparator<DataStore>(){

                @Override
                public int compare(DataStore dataStore, DataStore dataStore2) {
                    return dataStore.getNumberBlocks() - dataStore2.getNumberBlocks();
                }
            });
            priorityQueue.addAll(list);
            if (null != this.m_logger) {
                LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            }
            this.m_blockConverter.setMemLimit(this.m_properties.m_blockSize);
            PriorityQueue<IRowView> priorityQueue2 = new PriorityQueue<IRowView>(2, this.m_comparator);
            DataStore dataStore = null;
            DataStore dataStore2 = null;
            boolean bl2 = false;
            try {
                int n = 1;
                while (priorityQueue.size() > 1) {
                    void var10_14;
                    int n2 = (int)((this.m_memAssigned - this.m_properties.m_blockSize) / this.m_properties.m_blockSize);
                    if (n2 > this.m_properties.m_maxOpenFiles - 1) {
                        n2 = this.m_properties.m_maxOpenFiles - 1;
                    }
                    dataStore = new DataStore(this.m_properties, this.m_columnMeta);
                    boolean i = false;
                    while (var10_14 < n2 && priorityQueue.size() > 0) {
                        dataStore2 = priorityQueue.poll();
                        if (dataStore2.numberOfBlocksHeld() < 1) {
                            dataStore2.giveBlock();
                        }
                        dataStore2.moveToNextRow();
                        priorityQueue2.add(dataStore2);
                        ++var10_14;
                    }
                    dataStore2 = null;
                    if (priorityQueue2.size() < n2) {
                        if (!bl) {
                            long l = this.m_memAssigned - (long)priorityQueue2.size() * this.m_properties.m_blockSize;
                            assert (l > 0L);
                            this.m_memAgent.recycleMemory(l);
                            this.m_memAssigned -= l;
                        }
                        this.m_currentStage = Stage.MERGE_LAST;
                    }
                    if (null != this.m_logger && LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_logger)) {
                        LogUtilities.logDebug(String.format("Pass %d: Merging %d of %d chunks.", n, priorityQueue2.size(), priorityQueue2.size() + priorityQueue.size()), this.m_logger);
                    }
                    while (priorityQueue2.size() > 0) {
                        dataStore2 = (DataStore)priorityQueue2.poll();
                        if (!this.m_blockConverter.appendRow()) {
                            this.m_cancelState.checkCancel();
                            dataStore.put(this.m_blockConverter.toRowBlock());
                            this.m_blockConverter.appendRow();
                        }
                        this.copyRow(dataStore2, this.m_blockConverter);
                        if (dataStore2.moveToNextRow()) {
                            priorityQueue2.add(dataStore2);
                            continue;
                        }
                        dataStore2.destroy();
                    }
                    RowBlock iRowView = this.m_blockConverter.toRowBlock();
                    if (iRowView != null) {
                        dataStore.put(iRowView);
                    }
                    priorityQueue.add(dataStore);
                    dataStore = null;
                    ++n;
                }
                bl2 = true;
                dataStore3 = priorityQueue.poll();
                if (bl2) break block24;
            }
            catch (Throwable throwable) {
                if (!bl2) {
                    for (DataStore dataStore4 : priorityQueue2) {
                        dataStore4.destroy();
                    }
                    for (DataStore dataStore4 : priorityQueue) {
                        dataStore4.destroy();
                    }
                    if (dataStore != null) {
                        dataStore.destroy();
                    }
                    if (dataStore2 != null) {
                        dataStore2.destroy();
                    }
                }
                throw throwable;
            }
            for (DataStore dataStore5 : priorityQueue2) {
                dataStore5.destroy();
            }
            for (DataStore dataStore6 : priorityQueue) {
                dataStore6.destroy();
            }
            if (dataStore != null) {
                dataStore.destroy();
            }
            if (dataStore2 != null) {
                dataStore2.destroy();
            }
        }
        return dataStore3;
    }

    private void copyRow(DataStore dataStore, BlockConverter blockConverter) {
        block16: for (int i = 0; i < this.m_columnMeta.length; ++i) {
            if (dataStore.isNull(i)) {
                blockConverter.setNull(i);
                continue;
            }
            if (ColumnSizeCalculator.isLongData(this.m_columnMeta[i], this.m_properties.m_maxDataLen)) {
                blockConverter.setFileMarker(i, dataStore.getFileMarker(i));
                continue;
            }
            switch (this.m_columnMeta[i].getTypeMetadata().getType()) {
                case -4: 
                case -3: 
                case -2: {
                    blockConverter.setBytes(i, dataStore.getBytes(i));
                    continue block16;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    blockConverter.setString(i, dataStore.getString(i));
                    continue block16;
                }
                case -7: 
                case 16: {
                    blockConverter.setBoolean(i, dataStore.getBoolean(i));
                    continue block16;
                }
                case -6: {
                    blockConverter.setTinyInt(i, dataStore.getTinyInt(i));
                    continue block16;
                }
                case 5: {
                    blockConverter.setSmallInt(i, dataStore.getSmallInt(i));
                    continue block16;
                }
                case 4: {
                    blockConverter.setInteger(i, dataStore.getInteger(i));
                    continue block16;
                }
                case -5: {
                    blockConverter.setBigInt(i, dataStore.getBigInt(i));
                    continue block16;
                }
                case 7: {
                    blockConverter.setReal(i, dataStore.getReal(i));
                    continue block16;
                }
                case 6: 
                case 8: {
                    blockConverter.setDouble(i, dataStore.getDouble(i));
                    continue block16;
                }
                case 2: 
                case 3: {
                    blockConverter.setExactNum(i, dataStore.getExactNumber(i));
                    continue block16;
                }
                case 91: {
                    blockConverter.setDate(i, dataStore.getDate(i));
                    continue block16;
                }
                case 92: {
                    blockConverter.setTime(i, dataStore.getTime(i));
                    continue block16;
                }
                case 93: {
                    blockConverter.setTimestamp(i, dataStore.getTimestamp(i));
                    continue block16;
                }
                case -11: {
                    blockConverter.setGuid(i, dataStore.getGuid(i));
                    continue block16;
                }
                default: {
                    throw new IllegalStateException("Unknown column type");
                }
            }
        }
    }

    public void setFileMarker(int n, TemporaryFile.FileMarker fileMarker) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setFileMarker(n, fileMarker);
    }

    public void setNull(int n) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setNull(n);
    }

    public void setBigInt(int n, long l) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setBigInt(n, l);
    }

    public void setExactNum(int n, BigDecimal bigDecimal) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setExactNum(n, bigDecimal);
    }

    public void setDouble(int n, double d) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setDouble(n, d);
    }

    public void setReal(int n, float f) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setReal(n, f);
    }

    public void setBoolean(int n, boolean bl) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setBoolean(n, bl);
    }

    public void setString(int n, String string) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setString(n, string);
    }

    public void setDate(int n, Date date) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setDate(n, date);
    }

    public void setTime(int n, Time time) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setTimestamp(n, timestamp);
    }

    public void setGuid(int n, UUID uUID) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setGuid(n, uUID);
    }

    public void setInteger(int n, int n2) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setInteger(n, n2);
    }

    public void setSmallInt(int n, short s) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setSmallInt(n, s);
    }

    public void setTinyInt(int n, byte by) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setTinyInt(n, by);
    }

    public void setBytes(int n, byte[] byArray) {
        assert (this.m_currentStage == Stage.FIRST_PASS) : "Sorter call sequence error.";
        this.m_onePassSorter.setBytes(n, byArray);
    }

    public void reset(boolean bl) {
        this.m_currentStage = Stage.FIRST_PASS;
        if (this.m_onePassSorter != null) {
            this.m_onePassSorter.destroy();
            this.m_onePassSorter = null;
        }
        this.m_blockConverter.reset();
        this.m_blockConverter.setMemLimit(0L);
        if (this.m_memAssigned != 0L && !bl) {
            this.m_memAgent.recycleMemory(this.m_memAssigned);
            this.m_memAssigned = 0L;
        }
    }

    @Override
    public long getRequiredMemory() {
        return this.m_properties.m_blockSize * 3L + (long)this.m_blockConverter.getMemOverhead();
    }

    RowComparator getRowComparator() {
        return this.m_comparator;
    }

    @Override
    public void registerManagerAgent(IMemManagerAgent iMemManagerAgent) {
        this.m_memAgent = iMemManagerAgent;
    }

    @Override
    public long assign(long l) {
        switch (this.m_currentStage) {
            case FIRST_PASS: {
                if (this.m_onePassSorter != null) {
                    this.m_onePassSorter.increaseMemoryUsage(l);
                }
                this.m_memAssigned += l;
                return l;
            }
            case MERGING: {
                this.m_memAssigned += l;
                return l;
            }
            case MERGE_LAST: 
            case FINISHED: {
                return 0L;
            }
        }
        throw new IllegalStateException("Unknown state.");
    }

    private static enum Stage {
        FIRST_PASS,
        MERGING,
        MERGE_LAST,
        FINISHED;

    }
}

