/*
 * Decompiled with CFR 0.152.
 */
package jd2.xml.sa.uscb;

import ec.tstoolkit.modelling.arima.x13.MovingHolidaySpec;
import ec.tstoolkit.modelling.arima.x13.RegressionSpec;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import jd2.xml.sa.uscb.AbstractXmlTdVariables;
import jd2.xml.sa.uscb.XmlMovingHolidaySpec;
import jd2.xml.sa.uscb.XmlTradingDaysSpec;

@XmlType(name="calendarSpecType")
public class XmlCalendarSpec {
    static final String NAME = "calendarSpecType";
    @XmlElements(value={@XmlElement(name="tdVariables", type=XmlTradingDaysSpec.class)})
    public AbstractXmlTdVariables td;
    @XmlElementWrapper(name="movingHolidaySpec")
    @XmlElement(name="movingHolidaySpecType")
    public XmlMovingHolidaySpec[] movingHolidaySpec;
    @XmlElement
    public Double aiccDiff = 0.0;

    public boolean isAiccDiffSpecified() {
        return this.aiccDiff != null;
    }

    public static XmlCalendarSpec create(RegressionSpec spec) {
        MovingHolidaySpec[] mh;
        if (spec == null) {
            return null;
        }
        XmlCalendarSpec x = new XmlCalendarSpec();
        x.aiccDiff = spec.getAICCDiff();
        if (spec.getTradingDays().isUsed()) {
            XmlTradingDaysSpec td = new XmlTradingDaysSpec();
            td.copy(spec.getTradingDays());
            x.td = td;
        }
        if ((mh = spec.getMovingHolidays()) != null) {
            XmlMovingHolidaySpec[] xmh = new XmlMovingHolidaySpec[mh.length];
            for (int i = 0; i < xmh.length; ++i) {
                xmh[i] = new XmlMovingHolidaySpec();
                xmh[i].copy(mh[i]);
            }
            x.movingHolidaySpec = xmh;
        }
        return x;
    }

    public void initSpec(RegressionSpec spec) {
        if (this.isAiccDiffSpecified()) {
            spec.setAICCDiff(this.aiccDiff.doubleValue());
        }
        if (this.td != null) {
            this.td.copyTo(spec);
        }
        if (this.movingHolidaySpec != null) {
            MovingHolidaySpec[] mh = new MovingHolidaySpec[this.movingHolidaySpec.length];
            for (int i = 0; i < this.movingHolidaySpec.length; ++i) {
                mh[i] = this.movingHolidaySpec[i].create();
            }
            spec.setMovingHolidays(mh);
        }
    }
}

