/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.simplets;

import ec.benchmarking.DisaggregationModel;
import ec.benchmarking.simplets.TsDisaggregation;
import ec.tstoolkit.Parameter;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.maths.realfunctions.GridSearch;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.arima.SsfAr1;
import ec.tstoolkit.ssf.arima.SsfArima;
import ec.tstoolkit.ssf.arima.SsfRw;
import ec.tstoolkit.ssf.arima.SsfRwAr1;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.regression.Constant;
import ec.tstoolkit.timeseries.regression.LinearTrend;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

public class TsDisaggregation2 {
    public static final double DEF_EPS = 1.0E-5;
    private Model model = Model.Ar1;
    private boolean constant = true;
    private boolean trend;
    private boolean log;
    private boolean diffuseRegressors;
    private boolean zeroinit;
    private boolean ml = true;
    private Parameter p = new Parameter();
    private double truncated = 0.0;
    private TsAggregationType type = TsAggregationType.Sum;
    private TsDisaggregation.SsfOption option = TsDisaggregation.SsfOption.DKF;
    private double eps = 1.0E-5;
    private TsPeriodSelector span = new TsPeriodSelector();
    private TsFrequency defaultFrequency = TsFrequency.Quarterly;
    private TsDisaggregation<? extends ISsf> result;
    private int nindicators;

    public boolean process(TsData y, TsVariableList x) {
        TsDisaggregation<ISsf> disagg;
        DisaggregationModel dmodel = this.prepare(y, x);
        if (dmodel == null) {
            return false;
        }
        switch (this.model.ordinal()) {
            case 1: {
                disagg = this.initChowLin();
                break;
            }
            case 0: {
                disagg = this.initOLS();
                break;
            }
            case 2: {
                disagg = this.initFernandez();
                break;
            }
            case 3: {
                disagg = this.initLitterman();
                break;
            }
            default: {
                disagg = this.initI(this.model.getDifferencingOrder());
            }
        }
        disagg.useML(this.ml);
        disagg.calculateVariance(true);
        disagg.setSsfOption(this.option);
        if (this.diffuseRegressors) {
            disagg.setDiffuseRegressorsCount(dmodel.getX().getVariablesCount());
        }
        disagg.setEpsilon(this.eps);
        if (!disagg.process(dmodel, null)) {
            return false;
        }
        int n = dmodel.getX().getVariablesCount();
        if (this.isConstant()) {
            --n;
        }
        if (this.isTrend()) {
            --n;
        }
        this.result = disagg;
        this.nindicators = n;
        return true;
    }

    public DiffuseConcentratedLikelihood getLikelihood() {
        return this.result.getLikelihood();
    }

    public LikelihoodStatistics getLikelihoodStatistics() {
        DiffuseConcentratedLikelihood ll = this.result.getLikelihood();
        IParametricMapping<? extends ISsf> mapping = this.result.getMapping();
        return LikelihoodStatistics.create(ll, ll.getN(), mapping == null ? 0 : mapping.getDim(), 0.0);
    }

    public IFunction getEstimationFunction() {
        return this.result.getEstimationFunction();
    }

    public IFunctionInstance getMin() {
        return this.result.getMin();
    }

    public Parameter getEstimatedParameter() {
        Matrix i = this.result.getObservedInformation();
        if (i == null) {
            return null;
        }
        IParametricMapping<? extends ISsf> mapping = this.result.getMapping();
        IReadDataBlock p = mapping.map(this.result.getEstimatedSsf());
        Parameter x = new Parameter(p.get(0), ParameterType.Estimated);
        x.setStde(Math.sqrt(1.0 / i.get(0, 0)));
        return x;
    }

    public ISsf getEstimatedSsf() {
        return this.result.getEstimatedSsf();
    }

    public void reset() {
        this.result = null;
        this.nindicators = 0;
        this.model = Model.Ar1;
        this.constant = true;
        this.trend = false;
        this.log = false;
        this.diffuseRegressors = false;
        this.zeroinit = false;
        this.ml = true;
        this.p = new Parameter();
        this.type = TsAggregationType.Sum;
        this.option = TsDisaggregation.SsfOption.DKF;
        this.eps = 1.0E-5;
        this.span = new TsPeriodSelector();
    }

    public TsAggregationType getType() {
        return this.type;
    }

    public void setType(TsAggregationType type) {
        this.type = type;
    }

    public double getEpsilon() {
        return this.eps;
    }

    public void setEpsilon(double eps) {
        this.eps = eps;
    }

    public boolean isZeroInitialization() {
        return this.zeroinit;
    }

    public void setZeroInitialization(boolean zeroinit) {
        this.zeroinit = zeroinit;
    }

    public boolean isML() {
        return this.ml;
    }

    public void setML(boolean ml) {
        this.ml = ml;
    }

    public Parameter getParameter() {
        return this.p;
    }

    public void setParameter(Parameter p) {
        this.p = p;
    }

    public TsPeriodSelector getSpan() {
        return this.span;
    }

    public void setSpan(TsPeriodSelector span) {
        if (span == null) {
            throw new AssertionError((Object)"Span should not be null");
        }
        this.span = span;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model aModel) {
        this.model = aModel;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public boolean isTrend() {
        return this.trend;
    }

    public void setTrend(boolean trend) {
        this.trend = trend;
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public boolean isDiffuseRegression() {
        return this.diffuseRegressors;
    }

    public void setDiffuseRegression(boolean diffuseRegressors) {
        this.diffuseRegressors = diffuseRegressors;
    }

    public double getTruncatedRho() {
        return this.truncated;
    }

    public void setTruncatedRho(double lrho) {
        if (lrho > 0.0 || lrho < -1.0) {
            throw new IllegalArgumentException("Truncated value should be in [-1,0]");
        }
        this.truncated = lrho;
    }

    public TsDisaggregation.SsfOption getOption() {
        return this.option;
    }

    public void setOption(TsDisaggregation.SsfOption option) {
        this.option = option;
    }

    public TsFrequency getDefaultFrequency() {
        return this.defaultFrequency;
    }

    public void setDefaultFrequency(TsFrequency freq) {
        this.defaultFrequency = freq;
    }

    private TsDisaggregation<SsfAr1> initChowLin() {
        TsDisaggregation<SsfAr1> disagg = new TsDisaggregation<SsfAr1>();
        SsfAr1 ssf = new SsfAr1();
        Parameter p = this.getParameter();
        GridSearch gsearch = new GridSearch();
        gsearch.setPrecision(this.eps);
        if (p != null && p.isFixed()) {
            ssf.setRho(p.getValue());
        } else {
            disagg.setMapping(new SsfAr1.Mapping(this.isZeroInitialization(), this.getTruncatedRho(), 1.0));
            gsearch.setBounds(this.getTruncatedRho(), 1.0);
        }
        ssf.useZeroInitialization(this.isZeroInitialization());
        disagg.setSsf(ssf);
        disagg.setMinimizer(gsearch);
        return disagg;
    }

    private TsDisaggregation<SsfAr1> initOLS() {
        TsDisaggregation<SsfAr1> disagg = new TsDisaggregation<SsfAr1>();
        SsfAr1 ssf = new SsfAr1();
        ssf.setRho(0.0);
        disagg.setSsf(ssf);
        return disagg;
    }

    private TsDisaggregation<SsfRwAr1> initLitterman() {
        TsDisaggregation<SsfRwAr1> disagg = new TsDisaggregation<SsfRwAr1>();
        SsfRwAr1 ssf = new SsfRwAr1();
        Parameter p = this.getParameter();
        GridSearch gsearch = new GridSearch();
        gsearch.setPrecision(this.eps);
        if (p != null && p.isFixed()) {
            ssf.setRho(p.getValue());
        } else {
            disagg.setMapping(new SsfRwAr1.Mapping(this.isZeroInitialization(), this.getTruncatedRho(), 1.0));
            gsearch.setBounds(this.getTruncatedRho(), 1.0);
        }
        ssf.useZeroInitialization(this.isZeroInitialization());
        disagg.setSsf(ssf);
        disagg.setMinimizer(gsearch);
        return disagg;
    }

    private TsDisaggregation<SsfRw> initFernandez() {
        TsDisaggregation<SsfRw> disagg = new TsDisaggregation<SsfRw>();
        SsfRw ssf = new SsfRw();
        ssf.useZeroInitialization(this.isZeroInitialization());
        disagg.setSsf(ssf);
        return disagg;
    }

    private TsDisaggregation<SsfArima> initI(int diff) {
        TsDisaggregation<SsfArima> disagg = new TsDisaggregation<SsfArima>();
        ArimaModel sarima = new ArimaModel(null, new BackFilter(UnitRoots.D(1, diff)), null, 1.0);
        SsfArima ssf = new SsfArima(sarima);
        disagg.setSsf(ssf);
        return disagg;
    }

    private DisaggregationModel prepare(TsData y, TsVariableList x) {
        TsVariableList xc;
        if (y == null) {
            return null;
        }
        TsData yc = y.select(this.getSpan());
        DisaggregationModel model = new DisaggregationModel(this.defaultFrequency);
        model.setY(yc);
        if (x == null || x.isEmpty()) {
            if (this.defaultFrequency == TsFrequency.Undefined || !yc.getFrequency().contains(this.defaultFrequency)) {
                return null;
            }
            model.setDefaultForecastCount(this.defaultFrequency.intValue());
            xc = new TsVariableList();
        } else {
            xc = x.clone();
        }
        if (this.isConstant() && (this.getModel().isStationary() || this.isZeroInitialization())) {
            xc.add(new Constant());
        }
        if (this.isTrend()) {
            xc.add(new LinearTrend(y.getStart().firstday()));
        }
        if (!xc.isEmpty()) {
            model.setX(xc);
        }
        model.setAggregationType(this.getType());
        return model;
    }

    public TsData getDisaggregtedSeries() {
        return this.result == null ? null : this.result.getSmoothedSeries();
    }

    public TsData getDisaggregtedSeriesVariance() {
        return this.result == null ? null : this.result.getSmoothedSeriesVariance();
    }

    public static enum Model {
        Wn,
        Ar1,
        Rw,
        RwAr1,
        I2,
        I3;


        public boolean hasParameter() {
            return this == Ar1 || this == RwAr1;
        }

        public boolean isStationary() {
            return this == Ar1 || this == Wn;
        }

        public int getParametersCount() {
            return this == Ar1 || this == RwAr1 ? 1 : 0;
        }

        public int getDifferencingOrder() {
            switch (this.ordinal()) {
                case 2: 
                case 3: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 5: {
                    return 3;
                }
            }
            return 0;
        }
    }
}

