/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.ISaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.satoolkit.diagnostics.CombinedSeasonalityTest;
import ec.satoolkit.diagnostics.FTest;
import ec.satoolkit.diagnostics.KruskalWallisTest;
import ec.satoolkit.x11.DefaultSeasonalFilteringStrategy;
import ec.satoolkit.x11.DefaultTrendFilteringStrategy;
import ec.satoolkit.x11.FilterFactory;
import ec.satoolkit.x11.FilteredMeanEndPoints;
import ec.satoolkit.x11.MsrTable;
import ec.satoolkit.x11.SeriesEvolution;
import ec.satoolkit.x11.TrendCycleFilterFactory;
import ec.satoolkit.x11.X11Results;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.data.AutoCorrelations;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.diagnostics.OneStepAheadForecastingTest;
import ec.tstoolkit.modelling.arima.tramo.SeasonalityTests;
import ec.tstoolkit.modelling.arima.tramo.SpectralPeaks;
import ec.tstoolkit.stats.StatisticalTest;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.GregorianCalendarVariables;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class GenericSaDiagnostics
implements IProcResults {
    private final PreprocessingModel regarima;
    private final ISaResults decomposition;
    private final ISeriesDecomposition finals;
    private final boolean mul;
    private final TsData lin;
    private final TsData res;
    private final TsData sa;
    private final TsData irr;
    private final TsData si;
    private final TsData s;
    private final TsData t;
    private SeasonalityTests ytests;
    private SeasonalityTests rtests;
    private SeasonalityTests satests;
    private SeasonalityTests itests;
    private CombinedSeasonalityTest seasSI;
    private CombinedSeasonalityTest seasSa;
    private CombinedSeasonalityTest seasI;
    private CombinedSeasonalityTest seasRes;
    private CombinedSeasonalityTest seasSa3;
    private CombinedSeasonalityTest seasI3;
    private CombinedSeasonalityTest seasRes3;
    private OneStepAheadForecastingTest outOfSampleTest;
    private MsrTable msr;
    private static final double FLEN = 1.5;
    public static final String SEAS_LIN_QS = "seas-lin-qs";
    public static final String SEAS_LIN_F = "seas-lin-f";
    public static final String SEAS_LIN_FRIEDMAN = "seas-lin-friedman";
    public static final String SEAS_LIN_KW = "seas-lin-kw";
    public static final String SEAS_LIN_PERIODOGRAM = "seas-lin-periodogram";
    public static final String SEAS_LIN_SP = "seas-lin-spectralpeaks";
    public static final String SEAS_SI_COMBINED = "seas-si-combined";
    public static final String SEAS_SI_EVOLUTIVE = "seas-si-evolutive";
    public static final String SEAS_SI_STABLE = "seas-si-stable";
    public static final String SEAS_RES_QS = "seas-res-qs";
    public static final String SEAS_RES_F = "seas-res-f";
    public static final String SEAS_RES_FRIEDMAN = "seas-res-friedman";
    public static final String SEAS_RES_KW = "seas-res-kw";
    public static final String SEAS_RES_PERIODOGRAM = "seas-res-periodogram";
    public static final String SEAS_RES_COMBINED = "seas-res-combined";
    public static final String SEAS_RES_COMBINED3 = "seas-res-combined3";
    public static final String SEAS_RES_EVOLUTIVE = "seas-res-evolutive";
    public static final String SEAS_RES_STABLE = "seas-res-stable";
    public static final String SEAS_RES_SP = "seas-res-spectralpeaks";
    public static final String SEAS_SA_QS = "seas-sa-qs";
    public static final String SEAS_SA_F = "seas-sa-f";
    public static final String SEAS_SA_FRIEDMAN = "seas-sa-friedman";
    public static final String SEAS_SA_KW = "seas-sa-kw";
    public static final String SEAS_SA_PERIODOGRAM = "seas-sa-periodogram";
    public static final String SEAS_SA_COMBINED = "seas-sa-combined";
    public static final String SEAS_SA_COMBINED3 = "seas-sa-combined3";
    public static final String SEAS_SA_STABLE = "seas-sa-stable";
    public static final String SEAS_SA_EVOLUTIVE = "seas-sa-evolutive";
    public static final String SEAS_SA_SP = "seas-sa-spectralpeaks";
    public static final String SEAS_SA_AC1 = "seas-sa-ac1";
    public static final String SEAS_I_QS = "seas-i-qs";
    public static final String SEAS_I_F = "seas-i-f";
    public static final String SEAS_I_FRIEDMAN = "seas-i-friedman";
    public static final String SEAS_I_KW = "seas-i-kw";
    public static final String SEAS_I_PERIODOGRAM = "seas-i-periodogram";
    public static final String SEAS_I_COMBINED = "seas-i-combined";
    public static final String SEAS_I_COMBINED3 = "seas-i-combined3";
    public static final String SEAS_I_STABLE = "seas-i-stable";
    public static final String SEAS_I_EVOLUTIVE = "seas-i-evolutive";
    public static final String SEAS_I_SP = "seas-i-spectralpeaks";
    public static final String FCAST_INSAMPLE_MEAN = "fcast-insample-mean";
    public static final String FCAST_OUTSAMPLE_MEAN = "fcast-outsample-mean";
    public static final String FCAST_OUTSAMPLE_VARIANCE = "fcast-outsample-variance";
    public static final String LOG_STAT = "logstat";
    public static final String LEVEL_STAT = "levelstat";
    public static final String TD_RES_ALL = "td-res-all";
    public static final String TD_RES_LAST = "td-res-last";
    public static final String TD_I_ALL = "td-i-all";
    public static final String TD_I_LAST = "td-i-last";
    public static final String TD_SA_ALL = "td-sa-all";
    public static final String TD_SA_LAST = "td-sa-last";
    public static final String IC_RATIO = "ic-ratio";
    public static final String IC_RATIO_HENDERSON = "ic-ratio-henderson";
    public static final String MSR_GLOBAL = "msr-global";
    public static final String MSR = "msr";
    private static final InformationMapping<GenericSaDiagnostics> MAPPING = new InformationMapping<GenericSaDiagnostics>(GenericSaDiagnostics.class);

    public static GenericSaDiagnostics of(PreprocessingModel regarima, ISaResults decomposition, ISeriesDecomposition finals) {
        if (decomposition == null || finals == null) {
            return null;
        }
        return new GenericSaDiagnostics(regarima, decomposition, finals);
    }

    private GenericSaDiagnostics(PreprocessingModel regarima, ISaResults decomposition, ISeriesDecomposition finals) {
        this.regarima = regarima;
        this.decomposition = decomposition;
        this.finals = finals;
        this.sa = decomposition.getData("sa_cmp", TsData.class);
        this.t = decomposition.getData("t_cmp", TsData.class);
        this.s = decomposition.getData("s_cmp", TsData.class);
        this.irr = decomposition.getData("i_cmp", TsData.class);
        this.mul = decomposition.getSeriesDecomposition().getMode().isMultiplicative();
        if (regarima == null) {
            this.lin = decomposition.getData("y_cmp", TsData.class);
            this.res = null;
        } else {
            this.lin = regarima.linearizedSeries();
            this.res = regarima.getFullResiduals();
        }
        this.si = decomposition instanceof X11Results ? ((X11Results)decomposition).getData(InformationSet.concatenate("d-tables", "d8"), TsData.class) : (this.mul ? TsData.multiply(this.s, this.irr) : TsData.add(this.s, this.irr));
    }

    private SeasonalityTests resTests() {
        if (this.res == null) {
            return null;
        }
        if (this.rtests == null) {
            this.rtests = SeasonalityTests.seasonalityTest(this.res, 0, false, true);
        }
        return this.rtests;
    }

    private SeasonalityTests yTests() {
        if (this.ytests == null) {
            this.ytests = SeasonalityTests.seasonalityTest(this.lin, 1, true, true);
        }
        return this.ytests;
    }

    private SeasonalityTests saTests() {
        if (this.satests == null) {
            this.satests = SeasonalityTests.seasonalityTest(this.mul ? this.sa.log() : this.sa, 1, true, true);
        }
        return this.satests;
    }

    private SeasonalityTests irrTests() {
        if (this.itests == null) {
            this.itests = SeasonalityTests.seasonalityTest(this.mul ? this.irr.log() : this.irr, 0, true, true);
        }
        return this.itests;
    }

    private CombinedSeasonalityTest csiTest() {
        if (this.seasSI == null) {
            this.seasSI = new CombinedSeasonalityTest(this.si, this.mul);
        }
        return this.seasSI;
    }

    private CombinedSeasonalityTest csaTest(boolean last) {
        if (last) {
            if (this.seasSa3 == null) {
                int freq = this.sa.getFrequency().intValue();
                TsData s = this.sa.delta(Math.max(1, freq / 4));
                TsPeriodSelector sel = new TsPeriodSelector();
                sel.last(freq * 3);
                this.seasSa3 = new CombinedSeasonalityTest(s.select(sel), this.mul);
            }
            return this.seasSa3;
        }
        if (this.seasSa == null) {
            int freq = this.sa.getFrequency().intValue();
            TsData s = this.sa.delta(Math.max(1, freq / 4));
            this.seasSa = new CombinedSeasonalityTest(s, this.mul);
        }
        return this.seasSa;
    }

    private CombinedSeasonalityTest cresTest(boolean last) {
        if (this.res == null) {
            return null;
        }
        int freq = this.res.getFrequency().intValue();
        if (this.res.getLength() < 3 * freq) {
            return null;
        }
        if (last) {
            if (this.seasRes3 == null) {
                TsPeriodSelector sel = new TsPeriodSelector();
                sel.last(freq * 3);
                this.seasRes3 = new CombinedSeasonalityTest(this.res.select(sel), false);
            }
            return this.seasRes3;
        }
        if (this.seasRes == null) {
            this.seasRes = new CombinedSeasonalityTest(this.res, false);
        }
        return this.seasRes;
    }

    private CombinedSeasonalityTest ciTest(boolean last) {
        if (last) {
            if (this.seasI3 == null) {
                int freq = this.irr.getFrequency().intValue();
                TsPeriodSelector sel = new TsPeriodSelector();
                sel.last(freq * 3);
                this.seasI3 = new CombinedSeasonalityTest(this.irr.select(sel), this.mul);
            }
            return this.seasI3;
        }
        if (this.seasI == null) {
            this.seasI = new CombinedSeasonalityTest(this.irr, this.mul);
        }
        return this.seasI;
    }

    private OneStepAheadForecastingTest forecastingTest() {
        if (this.regarima == null) {
            return null;
        }
        if (this.outOfSampleTest == null) {
            try {
                OneStepAheadForecastingTest os;
                int ifreq = this.regarima.description.getFrequency();
                int nback = (int)(1.5 * (double)ifreq);
                if (nback < 5) {
                    nback = 5;
                }
                if (!(os = new OneStepAheadForecastingTest(nback)).test(this.regarima.estimation.getRegArima())) {
                    return null;
                }
                this.outOfSampleTest = os;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.outOfSampleTest;
    }

    private static StatisticalTest tdAr(TsData s) {
        try {
            int i;
            RegModel reg = new RegModel();
            DataBlock y = new DataBlock(s);
            reg.setY(y.drop(1, 0));
            GregorianCalendarVariables tdvars = GregorianCalendarVariables.getDefault(TradingDaysType.TradingDays);
            int ntd = tdvars.getDim();
            TsDomain edomain = s.getDomain().drop(1, 0);
            ArrayList<DataBlock> bvars = new ArrayList<DataBlock>(ntd);
            for (i = 0; i < ntd; ++i) {
                bvars.add(new DataBlock(edomain.getLength()));
            }
            tdvars.data(edomain, bvars);
            reg.addX(y.drop(0, 1));
            for (i = 0; i < ntd; ++i) {
                DataBlock cur = (DataBlock)bvars.get(i);
                reg.addX(cur);
            }
            Ols ols = new Ols();
            reg.setMeanCorrection(true);
            if (!ols.process(reg)) {
                return null;
            }
            JointRegressionTest test = new JointRegressionTest(0.01);
            test.accept(ols.getLikelihood(), 0, 2, ntd, null);
            return test.getTest();
        }
        catch (Exception err) {
            return null;
        }
    }

    private static StatisticalTest td(TsData s) {
        try {
            int i;
            RegModel reg = new RegModel();
            DataBlock y = new DataBlock(s);
            y.add(-y.average());
            reg.setY(y);
            GregorianCalendarVariables tdvars = GregorianCalendarVariables.getDefault(TradingDaysType.TradingDays);
            int ntd = tdvars.getDim();
            TsDomain edomain = s.getDomain();
            ArrayList<DataBlock> bvars = new ArrayList<DataBlock>(ntd);
            for (i = 0; i < ntd; ++i) {
                bvars.add(new DataBlock(edomain.getLength()));
            }
            tdvars.data(edomain, bvars);
            for (i = 0; i < ntd; ++i) {
                DataBlock cur = (DataBlock)bvars.get(i);
                reg.addX(cur);
            }
            Ols ols = new Ols();
            if (!ols.process(reg)) {
                return null;
            }
            JointRegressionTest test = new JointRegressionTest(0.01);
            test.accept(ols.getLikelihood(), 0, 0, ntd, null);
            return test.getTest();
        }
        catch (Exception err) {
            return null;
        }
    }

    private MsrTable msr() {
        if (this.msr == null && this.s != null) {
            if (this.decomposition instanceof X11Results) {
                TsData s2;
                TsData d9;
                DecompositionMode mode = this.decomposition.getSeriesDecomposition().getMode();
                SymmetricFilter f7 = FilterFactory.makeSymmetricFilter(7);
                DefaultSeasonalFilteringStrategy fseas = new DefaultSeasonalFilteringStrategy(f7, new FilteredMeanEndPoints(f7));
                TsData d1 = this.decomposition.getData("d-tables.d1", TsData.class);
                TsData d7 = this.decomposition.getData("d-tables.d7", TsData.class);
                switch (mode) {
                    case Multiplicative: 
                    case PseudoAdditive: {
                        d9 = TsData.divide(d1, d7);
                        break;
                    }
                    case LogAdditive: {
                        d9 = TsData.divide(d1, d7).log();
                        break;
                    }
                    default: {
                        d9 = TsData.subtract(d1, d7);
                    }
                }
                TsData s1 = fseas.process(d9, null);
                switch (mode) {
                    case Multiplicative: {
                        s2 = TsData.divide(d9, s1);
                        break;
                    }
                    case PseudoAdditive: {
                        s2 = d9.minus(s1).plus(1.0);
                        break;
                    }
                    default: {
                        s2 = TsData.subtract(d9, s1);
                    }
                }
                return MsrTable.create(s1, s2, mode == DecompositionMode.Multiplicative || mode == DecompositionMode.PseudoAdditive);
            }
            this.msr = MsrTable.create(this.s, this.irr, this.mul);
        }
        return this.msr;
    }

    public static void fillDictionary(String prefix, Map<String, Class> map, boolean compact) {
        MAPPING.fillDictionary(prefix, map, compact);
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        GenericSaDiagnostics.fillDictionary(null, map, false);
        return map;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        return MAPPING.getData(this, id, tclass);
    }

    @Override
    public boolean contains(String id) {
        return MAPPING.contains(id);
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.emptyList();
    }

    public static InformationMapping<GenericSaDiagnostics> getMapping() {
        return MAPPING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void setMapping(String name, Class<T> tclass, Function<GenericSaDiagnostics, T> extractor) {
        InformationMapping<GenericSaDiagnostics> informationMapping = MAPPING;
        synchronized (informationMapping) {
            MAPPING.set(name, tclass, extractor);
        }
    }

    static {
        MAPPING.set(LOG_STAT, Double.class, source -> {
            if (source.regarima == null) {
                return null;
            }
            return source.regarima.getData(InformationSet.concatenate("transformation", "log"), Double.class);
        });
        MAPPING.set(LEVEL_STAT, Double.class, source -> {
            if (source.regarima == null) {
                return null;
            }
            return source.regarima.getData(InformationSet.concatenate("transformation", "level"), Double.class);
        });
        MAPPING.set(FCAST_INSAMPLE_MEAN, Double.class, source -> {
            OneStepAheadForecastingTest ftest = source.forecastingTest();
            if (ftest == null) {
                return null;
            }
            return ftest.inSampleMeanTest().getPValue();
        });
        MAPPING.set(FCAST_OUTSAMPLE_MEAN, Double.class, source -> {
            OneStepAheadForecastingTest ftest = source.forecastingTest();
            if (ftest == null) {
                return null;
            }
            return ftest.outOfSampleMeanTest().getPValue();
        });
        MAPPING.set(FCAST_OUTSAMPLE_VARIANCE, Double.class, source -> {
            OneStepAheadForecastingTest ftest = source.forecastingTest();
            if (ftest == null) {
                return null;
            }
            return ftest.mseTest().getPValue();
        });
        MAPPING.set(SEAS_LIN_F, Double.class, source -> {
            FTest ftest = new FTest();
            if (ftest.test(source.lin)) {
                return ftest.getFTest().getPValue();
            }
            return null;
        });
        MAPPING.set(SEAS_LIN_QS, Double.class, source -> {
            SeasonalityTests ytests = source.yTests();
            if (ytests == null) {
                return null;
            }
            return ytests.getQs().getPValue();
        });
        MAPPING.set(SEAS_LIN_KW, Double.class, source -> {
            KruskalWallisTest kw = new KruskalWallisTest(source.lin);
            return kw.getPValue();
        });
        MAPPING.set(SEAS_LIN_FRIEDMAN, Double.class, source -> {
            SeasonalityTests ytests = source.yTests();
            if (ytests == null) {
                return null;
            }
            return ytests.getNonParametricTest().getPValue();
        });
        MAPPING.set(SEAS_LIN_PERIODOGRAM, Double.class, source -> {
            SeasonalityTests ytests = source.yTests();
            if (ytests == null) {
                return null;
            }
            StatisticalTest ptest = ytests.getPeriodogramTest();
            return ptest == null ? null : Double.valueOf(ptest.getPValue());
        });
        MAPPING.set(SEAS_LIN_SP, String.class, source -> {
            SeasonalityTests ytests = source.yTests();
            if (ytests == null) {
                return null;
            }
            SpectralPeaks[] spectralPeaks = ytests.getSpectralPeaks();
            if (spectralPeaks == null) {
                return null;
            }
            return SpectralPeaks.format(spectralPeaks);
        });
        MAPPING.set(SEAS_SI_COMBINED, String.class, source -> {
            CombinedSeasonalityTest sitest = source.csiTest();
            if (sitest == null) {
                return null;
            }
            return sitest.getSummary().name();
        });
        MAPPING.set(SEAS_SI_EVOLUTIVE, Double.class, source -> {
            CombinedSeasonalityTest sitest = source.csiTest();
            if (sitest == null) {
                return null;
            }
            return sitest.getEvolutiveSeasonality().getPValue();
        });
        MAPPING.set(SEAS_SI_STABLE, Double.class, source -> {
            CombinedSeasonalityTest sitest = source.csiTest();
            if (sitest == null) {
                return null;
            }
            return sitest.getStableSeasonality().getPValue();
        });
        MAPPING.set(SEAS_RES_F, Double.class, source -> {
            if (source.res == null) {
                return null;
            }
            FTest ftest = new FTest();
            if (ftest.test(source.res)) {
                return ftest.getFTest().getPValue();
            }
            return null;
        });
        MAPPING.set(SEAS_RES_QS, Double.class, source -> {
            SeasonalityTests rtests = source.resTests();
            if (rtests == null) {
                return null;
            }
            return rtests.getQs().getPValue();
        });
        MAPPING.set(SEAS_RES_KW, Double.class, source -> {
            if (source.res == null) {
                return null;
            }
            KruskalWallisTest kw = new KruskalWallisTest(source.res);
            return kw.getPValue();
        });
        MAPPING.set(SEAS_RES_FRIEDMAN, Double.class, source -> {
            SeasonalityTests rtests = source.resTests();
            if (rtests == null) {
                return null;
            }
            return rtests.getNonParametricTest().getPValue();
        });
        MAPPING.set(SEAS_RES_PERIODOGRAM, Double.class, source -> {
            SeasonalityTests rtests = source.resTests();
            if (rtests == null) {
                return null;
            }
            StatisticalTest ptest = rtests.getPeriodogramTest();
            return ptest == null ? null : Double.valueOf(ptest.getPValue());
        });
        MAPPING.set(SEAS_RES_SP, String.class, source -> {
            SeasonalityTests rtests = source.resTests();
            if (rtests == null) {
                return null;
            }
            return SpectralPeaks.format(rtests.getSpectralPeaks());
        });
        MAPPING.set(SEAS_RES_COMBINED, String.class, source -> {
            CombinedSeasonalityTest rtest = source.cresTest(false);
            if (rtest == null) {
                return null;
            }
            return rtest.getSummary().name();
        });
        MAPPING.set(SEAS_RES_COMBINED3, String.class, source -> {
            CombinedSeasonalityTest rtest = source.cresTest(true);
            if (rtest == null) {
                return null;
            }
            return rtest.getSummary().name();
        });
        MAPPING.set(SEAS_RES_EVOLUTIVE, Double.class, source -> {
            CombinedSeasonalityTest rtest = source.cresTest(false);
            if (rtest == null) {
                return null;
            }
            return rtest.getEvolutiveSeasonality().getPValue();
        });
        MAPPING.set(SEAS_RES_STABLE, Double.class, source -> {
            CombinedSeasonalityTest rtest = source.cresTest(false);
            if (rtest == null) {
                return null;
            }
            return rtest.getStableSeasonality().getPValue();
        });
        MAPPING.set(SEAS_I_F, Double.class, source -> {
            FTest ftest = new FTest();
            if (ftest.test(source.irr)) {
                return ftest.getFTest().getPValue();
            }
            return null;
        });
        MAPPING.set(SEAS_I_QS, Double.class, source -> {
            SeasonalityTests itests = source.irrTests();
            if (itests == null) {
                return null;
            }
            return itests.getQs().getPValue();
        });
        MAPPING.set(SEAS_I_KW, Double.class, source -> {
            KruskalWallisTest kw = new KruskalWallisTest(source.irr);
            return kw.getPValue();
        });
        MAPPING.set(SEAS_I_PERIODOGRAM, Double.class, source -> {
            SeasonalityTests itests = source.irrTests();
            if (itests == null) {
                return null;
            }
            StatisticalTest ptest = itests.getPeriodogramTest();
            return ptest == null ? null : Double.valueOf(ptest.getPValue());
        });
        MAPPING.set(SEAS_I_SP, String.class, source -> {
            SeasonalityTests itests = source.irrTests();
            if (itests == null) {
                return null;
            }
            return SpectralPeaks.format(itests.getSpectralPeaks());
        });
        MAPPING.set(SEAS_I_COMBINED, String.class, source -> {
            CombinedSeasonalityTest itest = source.ciTest(false);
            if (itest == null) {
                return null;
            }
            return itest.getSummary().name();
        });
        MAPPING.set(SEAS_I_COMBINED3, String.class, source -> {
            CombinedSeasonalityTest itest = source.ciTest(true);
            if (itest == null) {
                return null;
            }
            return itest.getSummary().name();
        });
        MAPPING.set(SEAS_I_EVOLUTIVE, Double.class, source -> {
            CombinedSeasonalityTest itest = source.ciTest(false);
            if (itest == null) {
                return null;
            }
            return itest.getEvolutiveSeasonality().getPValue();
        });
        MAPPING.set(SEAS_I_STABLE, Double.class, source -> {
            CombinedSeasonalityTest itest = source.ciTest(false);
            if (itest == null) {
                return null;
            }
            return itest.getStableSeasonality().getPValue();
        });
        MAPPING.set(SEAS_SA_F, Double.class, source -> {
            FTest ftest = new FTest();
            if (ftest.test(source.sa)) {
                return ftest.getFTest().getPValue();
            }
            return null;
        });
        MAPPING.set(SEAS_SA_QS, Double.class, source -> {
            SeasonalityTests satests = source.saTests();
            if (satests == null) {
                return null;
            }
            return satests.getQs().getPValue();
        });
        MAPPING.set(SEAS_SA_KW, Double.class, source -> {
            KruskalWallisTest kw = new KruskalWallisTest(source.sa);
            return kw.getPValue();
        });
        MAPPING.set(SEAS_SA_FRIEDMAN, Double.class, source -> {
            SeasonalityTests satests = source.saTests();
            if (satests == null) {
                return null;
            }
            return satests.getNonParametricTest().getPValue();
        });
        MAPPING.set(SEAS_SA_PERIODOGRAM, Double.class, source -> {
            SeasonalityTests satests = source.saTests();
            if (satests == null) {
                return null;
            }
            StatisticalTest ptest = satests.getPeriodogramTest();
            return ptest == null ? null : Double.valueOf(ptest.getPValue());
        });
        MAPPING.set(SEAS_SA_SP, String.class, source -> {
            SeasonalityTests satests = source.saTests();
            if (satests == null) {
                return null;
            }
            return SpectralPeaks.format(satests.getSpectralPeaks());
        });
        MAPPING.set(SEAS_SA_COMBINED, String.class, source -> {
            CombinedSeasonalityTest satest = source.csaTest(false);
            if (satest == null) {
                return null;
            }
            return satest.getSummary().name();
        });
        MAPPING.set(SEAS_SA_COMBINED3, String.class, source -> {
            CombinedSeasonalityTest satest = source.csaTest(true);
            if (satest == null) {
                return null;
            }
            return satest.getSummary().name();
        });
        MAPPING.set(SEAS_SA_EVOLUTIVE, Double.class, source -> {
            CombinedSeasonalityTest satest = source.csaTest(false);
            if (satest == null) {
                return null;
            }
            return satest.getEvolutiveSeasonality().getPValue();
        });
        MAPPING.set(SEAS_SA_STABLE, Double.class, source -> {
            CombinedSeasonalityTest satest = source.csaTest(false);
            if (satest == null) {
                return null;
            }
            return satest.getStableSeasonality().getPValue();
        });
        MAPPING.set(SEAS_SA_AC1, Double.class, source -> {
            TsData dsa = source.sa.delta(1);
            AutoCorrelations ac = new AutoCorrelations(dsa);
            return ac.autoCorrelation(1);
        });
        MAPPING.set(TD_SA_ALL, Double.class, source -> {
            StatisticalTest test;
            TsData s = source.sa;
            if (source.mul) {
                s = s.log();
            }
            return (test = GenericSaDiagnostics.tdAr(s)) == null ? null : Double.valueOf(test.getPValue());
        });
        MAPPING.set(TD_SA_LAST, Double.class, source -> {
            TsData s = source.sa;
            if (source.mul) {
                s = s.log();
            }
            int ifreq = s.getFrequency().intValue();
            StatisticalTest test = GenericSaDiagnostics.tdAr(s = s.drop(Math.max(0, s.getLength() - ifreq * 8 - 1), 0));
            return test == null ? null : Double.valueOf(test.getPValue());
        });
        MAPPING.set(TD_I_ALL, Double.class, source -> {
            StatisticalTest test;
            TsData s = source.irr;
            if (source.mul) {
                s = s.log();
            }
            return (test = GenericSaDiagnostics.tdAr(s)) == null ? null : Double.valueOf(test.getPValue());
        });
        MAPPING.set(TD_I_LAST, Double.class, source -> {
            TsData s = source.irr;
            if (source.mul) {
                s = s.log();
            }
            int ifreq = s.getFrequency().intValue();
            StatisticalTest test = GenericSaDiagnostics.tdAr(s = s.drop(Math.max(0, s.getLength() - ifreq * 8 - 1), 0));
            return test == null ? null : Double.valueOf(test.getPValue());
        });
        MAPPING.set(TD_RES_ALL, Double.class, source -> {
            TsData s = source.res;
            if (s == null) {
                return null;
            }
            StatisticalTest test = GenericSaDiagnostics.td(s);
            return test == null ? null : Double.valueOf(test.getPValue());
        });
        MAPPING.set(TD_RES_LAST, Double.class, source -> {
            TsData s = source.res;
            if (s == null) {
                return null;
            }
            int ifreq = s.getFrequency().intValue();
            StatisticalTest test = GenericSaDiagnostics.td(s = s.drop(Math.max(0, s.getLength() - ifreq * 8 - 1), 0));
            return test == null ? null : Double.valueOf(test.getPValue());
        });
        MAPPING.set(IC_RATIO_HENDERSON, Double.class, source -> {
            TsData sa = source.sa;
            int freq = sa.getFrequency().intValue();
            int filterLength = freq + 1;
            SymmetricFilter trendFilter = TrendCycleFilterFactory.makeHendersonFilter(filterLength);
            DefaultTrendFilteringStrategy strategy = new DefaultTrendFilteringStrategy(trendFilter, null, filterLength + " terms Henderson moving average");
            TsData sc = strategy.process(sa, sa.getDomain());
            TsData si = source.mul ? TsData.divide(sa, sc) : TsData.subtract(sa, sc);
            double gc = SeriesEvolution.calcAbsMeanVariations(sc, null, 1, source.mul, null);
            double gi = SeriesEvolution.calcAbsMeanVariations(si, null, 1, source.mul, null);
            return (double)(12 / freq) * gi / gc;
        });
        MAPPING.set(IC_RATIO, Double.class, source -> {
            TsData sa = source.sa;
            int freq = sa.getFrequency().intValue();
            TsData sc = source.t;
            TsData si = source.mul ? TsData.divide(sa, sc) : TsData.subtract(sa, sc);
            double gc = SeriesEvolution.calcAbsMeanVariations(sc, null, 1, source.mul, null);
            double gi = SeriesEvolution.calcAbsMeanVariations(si, null, 1, source.mul, null);
            return (double)(12 / freq) * gi / gc;
        });
        MAPPING.set(MSR_GLOBAL, Double.class, source -> {
            MsrTable msr = source.msr();
            if (msr == null) {
                return null;
            }
            return msr.getGlobalMsr();
        });
        MAPPING.setList(MSR, 1, 12, Double.class, (source, i) -> {
            MsrTable msr = source.msr();
            if (msr == null) {
                return null;
            }
            return i <= 0 || i > msr.getCount() ? null : Double.valueOf(msr.getRMS(i - 1));
        });
    }
}

