/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Instance_Based_Learning.FRNN;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.FuzzyIBLAlgorithm;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.ReportTool;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.Timer;
import org.core.Files;

public class FRNN
extends FuzzyIBLAlgorithm {
    private double[] instance;
    private double[] k;
    private double[] classPosibility;
    private final double Q = 2.0;

    @Override
    protected void readParameters(String script) {
        String file = Files.readFile(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
    }

    public FRNN(String script) {
        this.readDataFiles(script);
        this.name = "Fuzzy Rough nearest neighbor";
        this.instance = new double[this.inputAtt];
        this.k = new double[this.inputAtt];
        this.classPosibility = new double[this.nClasses];
        ReportTool.setOutputFile(this.outFile[2]);
    }

    public void generateModel() {
        Timer.resetTime();
        Timer.setModelTime();
        System.out.println(this.name + " " + this.relation + " Model " + Timer.getModelTime() + "s");
    }

    private int classifyInstance(int index, boolean train) {
        int output = -1;
        if (train) {
            System.arraycopy(this.trainData[index], 0, this.instance, 0, this.inputAtt);
            this.computeKTrain(index);
        } else {
            System.arraycopy(this.testData[index], 0, this.instance, 0, this.inputAtt);
            this.computeKTest(index);
        }
        Arrays.fill(this.classPosibility, 0.0);
        for (int i = 0; i < this.trainData.length; ++i) {
            if (train && index == i) continue;
            double distance = 0.0;
            for (int j = 0; j < this.inputAtt; ++j) {
                distance += this.k[j] * (this.instance[j] - this.trainData[i][j]) * (this.instance[j] - this.trainData[i][j]);
            }
            if (!train) {
                int n = this.trainOutput[i];
                this.classPosibility[n] = this.classPosibility[n] + Math.exp(Math.pow(-1.0 * distance, 1.0)) / (double)this.trainData.length;
                continue;
            }
            int n = this.trainOutput[i];
            this.classPosibility[n] = this.classPosibility[n] + Math.exp(Math.pow(-1.0 * distance, 1.0)) / ((double)this.trainData.length - 1.0);
        }
        double max = Double.MIN_VALUE;
        output = -1;
        for (int c = 0; c < this.nClasses; ++c) {
            if (!(max < this.classPosibility[c])) continue;
            max = this.classPosibility[c];
            output = c;
        }
        return output;
    }

    private void computeKTrain(int index) {
        double exp = 2.0;
        for (int j = 0; j < this.inputAtt; ++j) {
            double sum = 0.0;
            for (int i = 0; i < this.trainData.length; ++i) {
                if (i == index) continue;
                double dist = this.trainData[index][j] - this.trainData[i][j];
                dist = Math.pow(dist, exp);
                sum += dist;
            }
            this.k[j] = sum != 0.0 ? ((double)this.trainData.length - 1.0) / (2.0 * sum) : 0.0;
        }
    }

    private void computeKTest(int index) {
        double exp = 2.0;
        for (int j = 0; j < this.inputAtt; ++j) {
            double sum = 0.0;
            for (int i = 0; i < this.trainData.length; ++i) {
                double dist = this.testData[index][j] - this.trainData[i][j];
                dist = Math.pow(dist, exp);
                sum += dist;
            }
            this.k[j] = sum != 0.0 ? ((double)this.trainData.length - 1.0) / (2.0 * sum) : 0.0;
        }
    }

    public void classifyTrain() {
        Timer.resetTime();
        this.classifyTrainSet();
        Timer.setTrainingTime();
        System.out.println(this.name + " " + this.relation + " Training " + Timer.getTrainingTime() + "s");
    }

    public void classifyTest() {
        Timer.resetTime();
        this.classifyTestSet();
        Timer.setTestTime();
        System.out.println(this.name + " " + this.relation + " Test " + Timer.getTestTime() + "s");
    }

    public void classifyTrainSet() {
        for (int i = 0; i < this.trainData.length; ++i) {
            this.trainPrediction[i] = this.classifyInstance(i, true);
        }
    }

    public void classifyTestSet() {
        for (int i = 0; i < this.testData.length; ++i) {
            this.testPrediction[i] = this.classifyInstance(i, false);
        }
    }

    public void printReport() {
        this.writeOutput(this.outFile[0], this.trainOutput, this.trainPrediction);
        this.writeOutput(this.outFile[1], this.testOutput, this.testPrediction);
        ReportTool.setResults(this.trainOutput, this.trainPrediction, this.testOutput, this.testPrediction, this.nClasses);
        ReportTool.printReport();
    }
}

