/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.realarray;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.realarray.RealArrayIndividual;
import net.sourceforge.jclec.realarray.RealArraySpecies;
import net.sourceforge.jclec.util.range.IRange;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RealArrayIndividualSpecies
extends RealArraySpecies
implements IConfigure {
    private static final long serialVersionUID = -7949495150686741289L;

    public RealArrayIndividualSpecies() {
    }

    public RealArrayIndividualSpecies(IRange[] genotypeSchema) {
        this.setGenotypeSchema(genotypeSchema);
    }

    public void setGenotypeSchema(IRange[] genotypeSchema) {
        this.genotypeSchema = genotypeSchema;
    }

    public RealArrayIndividual createIndividual() {
        return new RealArrayIndividual();
    }

    @Override
    public RealArrayIndividual createIndividual(double[] genotype) {
        return new RealArrayIndividual(genotype);
    }

    @Override
    public void configure(Configuration settings) {
        int genotypeLength = settings.getList("genotype-schema.locus[@type]").size();
        IRange[] genotypeSchema = new IRange[genotypeLength];
        int i = 0;
        while (i < genotypeLength) {
            String componentClassname = settings.getString("genotype-schema.locus(" + i + ")[@type]");
            try {
                Class<?> componentClass = Class.forName(componentClassname);
                genotypeSchema[i] = (IRange)componentClass.newInstance();
                if (genotypeSchema[i] instanceof IConfigure) {
                    ((IConfigure)((Object)genotypeSchema[i])).configure(settings.subset("genotype-schema.locus(" + i + ")"));
                }
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationRuntimeException("Illegal schema element classname");
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationRuntimeException("Problems creating an instance of schema element", e);
            }
            catch (InstantiationException e) {
                throw new ConfigurationRuntimeException("Problems creating an instance of schema element", e);
            }
            ++i;
        }
        this.setGenotypeSchema(genotypeSchema);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        tsb.append("schema", this.genotypeSchema);
        return tsb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof RealArrayIndividualSpecies) {
            EqualsBuilder eb = new EqualsBuilder();
            RealArrayIndividualSpecies raoth = (RealArrayIndividualSpecies)other;
            eb.append(this.genotypeSchema, raoth.genotypeSchema);
            return eb.isEquals();
        }
        return false;
    }
}

