/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Instance_Based_Learning.IF_KNN;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.FuzzyIBLAlgorithm;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.ReportTool;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.Timer;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.Util;
import org.core.Files;

public class IF_KNN
extends FuzzyIBLAlgorithm {
    private int K;
    private double mA;
    private double vA;
    private double mR;
    private double vR;
    private int k;
    private double[][] membership;
    private double[][] referenceMembership;
    private double[][] testMembership;

    @Override
    protected void readParameters(String script) {
        String file = Files.readFile(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
        String line = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.K = Integer.parseInt(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.mA = Double.parseDouble(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.vA = Double.parseDouble(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.mR = Double.parseDouble(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.vR = Double.parseDouble(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.k = Integer.parseInt(tokens.nextToken().substring(1));
    }

    public IF_KNN(String script) {
        this.readDataFiles(script);
        this.name = "IF_KNN";
        this.membership = new double[this.trainData.length][this.nClasses];
        for (int i = 0; i < this.trainData.length; ++i) {
            Arrays.fill(this.membership[i], -1.0);
        }
        this.referenceMembership = new double[this.referenceData.length][this.nClasses];
        this.testMembership = new double[this.testData.length][this.nClasses];
        ReportTool.setOutputFile(this.outFile[2]);
    }

    public void generateModel() {
        Timer.resetTime();
        this.computeMembership();
        Timer.setModelTime();
        System.out.println(this.name + " " + this.relation + " Model " + Timer.getModelTime() + "s");
    }

    private void computeMembership() {
        for (int instance = 0; instance < this.trainData.length; ++instance) {
            int i;
            int[] nearestN = new int[this.k];
            double[] minDist = new double[this.k];
            for (i = 0; i < this.k; ++i) {
                nearestN[i] = 0;
                minDist[i] = Double.MAX_VALUE;
            }
            for (i = 0; i < this.trainData.length; ++i) {
                double dist = Util.euclideanDistance(this.trainData[i], this.trainData[instance]);
                if (i == instance) continue;
                boolean stop = false;
                for (int j = 0; j < this.k && !stop; ++j) {
                    if (!(dist < minDist[j])) continue;
                    for (int l = this.k - 1; l >= j + 1; --l) {
                        minDist[l] = minDist[l - 1];
                        nearestN[l] = nearestN[l - 1];
                    }
                    minDist[j] = dist;
                    nearestN[j] = i;
                    stop = true;
                }
            }
            int[] selectedClasses = new int[this.nClasses];
            Arrays.fill(selectedClasses, 0);
            for (i = 0; i < this.k; ++i) {
                int n = this.trainOutput[nearestN[i]];
                selectedClasses[n] = selectedClasses[n] + 1;
            }
            Arrays.fill(this.membership[instance], 0.0);
            for (int i2 = 0; i2 < this.nClasses; ++i2) {
                double term = (double)selectedClasses[i2] / (double)this.k;
                this.membership[instance][i2] = this.trainOutput[instance] == i2 ? 0.51 + 0.49 * term : 0.49 * term;
            }
        }
    }

    public void classifyTrain() {
        Timer.resetTime();
        this.classifyTrainSet();
        Timer.setTrainingTime();
        System.out.println(this.name + " " + this.relation + " Training " + Timer.getTrainingTime() + "s");
    }

    public void classifyTest() {
        Timer.resetTime();
        this.classifyTestSet();
        Timer.setTestTime();
        System.out.println(this.name + " " + this.relation + " Test " + Timer.getTestTime() + "s");
    }

    public void classifyTrainSet() {
        for (int i = 0; i < this.trainData.length; ++i) {
            this.trainPrediction[i] = this.classifyTrainInstance(i, this.trainData[i]);
        }
    }

    public void classifyTestSet() {
        for (int i = 0; i < this.testData.length; ++i) {
            this.testPrediction[i] = this.classifyTestInstance(i, this.testData[i]);
        }
    }

    private int classifyTrainInstance(int index, double[] example) {
        int i;
        int[] nearestN = new int[this.K];
        double[] minDist = new double[this.K];
        for (i = 0; i < this.K; ++i) {
            nearestN[i] = 0;
            minDist[i] = Double.MAX_VALUE;
        }
        for (i = 0; i < this.trainData.length; ++i) {
            if (i == index) continue;
            double dist = Util.euclideanDistance(this.trainData[i], example);
            boolean stop = false;
            for (int j = 0; j < this.K && !stop; ++j) {
                if (!(dist < minDist[j])) continue;
                for (int l = this.K - 1; l >= j + 1; --l) {
                    minDist[l] = minDist[l - 1];
                    nearestN[l] = nearestN[l - 1];
                }
                minDist[j] = dist;
                nearestN[j] = i;
                stop = true;
            }
        }
        Arrays.fill(this.referenceMembership[index], 0.0);
        for (i = 0; i < this.K; ++i) {
            for (int c = 0; c < this.nClasses; ++c) {
                double[] dArray = this.referenceMembership[index];
                int n = c;
                dArray[n] = dArray[n] + this.computeVote(this.membership[nearestN[i]][c]);
            }
        }
        for (int c = 0; c < this.nClasses; ++c) {
            this.referenceMembership[index][c] = 0.5 * (1.0 + this.referenceMembership[index][c] / (double)this.K);
        }
        int result = this.computeClass(this.referenceMembership[index]);
        return result;
    }

    private int classifyTestInstance(int index, double[] example) {
        int i;
        int[] nearestN = new int[this.K];
        double[] minDist = new double[this.K];
        for (i = 0; i < this.K; ++i) {
            nearestN[i] = 0;
            minDist[i] = Double.MAX_VALUE;
        }
        for (i = 0; i < this.trainData.length; ++i) {
            double dist = Util.euclideanDistance(this.trainData[i], example);
            boolean stop = false;
            for (int j = 0; j < this.K && !stop; ++j) {
                if (!(dist < minDist[j])) continue;
                for (int l = this.K - 1; l >= j + 1; --l) {
                    minDist[l] = minDist[l - 1];
                    nearestN[l] = nearestN[l - 1];
                }
                minDist[j] = dist;
                nearestN[j] = i;
                stop = true;
            }
        }
        Arrays.fill(this.testMembership[index], 0.0);
        for (i = 0; i < this.K; ++i) {
            for (int c = 0; c < this.nClasses; ++c) {
                double[] dArray = this.testMembership[index];
                int n = c;
                dArray[n] = dArray[n] + this.computeVote(this.membership[nearestN[i]][c]);
            }
        }
        for (int c = 0; c < this.nClasses; ++c) {
            this.testMembership[index][c] = 0.5 * (1.0 + this.testMembership[index][c] / (double)this.K);
        }
        int result = this.computeClass(this.testMembership[index]);
        return result;
    }

    private double computeVote(double value) {
        double mem = value;
        double nonMem = 1.0 - value;
        if (mem >= this.mA && nonMem <= this.vA) {
            return mem;
        }
        if (mem < this.mR && nonMem > this.vR) {
            return -1.0 * nonMem;
        }
        return 0.0;
    }

    private int computeClass(double[] member) {
        int out = 0;
        double max = member[0];
        for (int i = 1; i < member.length; ++i) {
            if (!(max < member[i])) continue;
            max = member[i];
            out = i;
        }
        return out;
    }

    public void printReport() {
        this.writeOutput(this.outFile[0], this.trainOutput, this.trainPrediction);
        this.writeOutput(this.outFile[1], this.testOutput, this.testPrediction);
        ReportTool.setResults(this.trainOutput, this.trainPrediction, this.testOutput, this.testPrediction, this.nClasses);
        ReportTool.printReport();
    }
}

