/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core;

import java.io.Serializable;
import java.util.Enumeration;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.AttributeWeka;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Instances;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.UnassignedClassException;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.UnassignedDatasetException;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Utils;

public class Instance
implements Serializable {
    static final long serialVersionUID = 1482635194499365122L;
    protected static final double MISSING_VALUE = Double.NaN;
    protected Instances m_Dataset;
    protected double[] m_AttValues;
    protected double m_Weight;

    public Instance(Instance instance) {
        this.m_AttValues = instance.m_AttValues;
        this.m_Weight = instance.m_Weight;
        this.m_Dataset = null;
    }

    public Instance(double weight, double[] attValues) {
        this.m_AttValues = attValues;
        this.m_Weight = weight;
        this.m_Dataset = null;
    }

    public Instance(int numAttributes) {
        this.m_AttValues = new double[numAttributes];
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            this.m_AttValues[i] = Double.NaN;
        }
        this.m_Weight = 1.0;
        this.m_Dataset = null;
    }

    public AttributeWeka attribute(int index) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.attribute(index);
    }

    public AttributeWeka attributeSparse(int indexOfIndex) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.attribute(indexOfIndex);
    }

    public AttributeWeka classAttribute() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.classAttribute();
    }

    public int classIndex() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.classIndex();
    }

    public boolean classIsMissing() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        return this.isMissing(this.classIndex());
    }

    public double classValue() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        return this.value(this.classIndex());
    }

    public Object copy() {
        Instance result = new Instance(this);
        result.m_Dataset = this.m_Dataset;
        return result;
    }

    public Instances dataset() {
        return this.m_Dataset;
    }

    public void deleteAttributeAt(int position) {
        if (this.m_Dataset != null) {
            throw new RuntimeException("Instance has access to a dataset!");
        }
        this.forceDeleteAttributeAt(position);
    }

    public Enumeration enumerateAttributes() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.enumerateAttributes();
    }

    public boolean equalHeaders(Instance inst) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.equalHeaders(inst.m_Dataset);
    }

    public boolean hasMissingValue() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (i == this.classIndex() || !this.isMissing(i)) continue;
            return true;
        }
        return false;
    }

    public int index(int position) {
        return position;
    }

    public void insertAttributeAt(int position) {
        if (this.m_Dataset != null) {
            throw new RuntimeException("Instance has accesss to a dataset!");
        }
        if (position < 0 || position > this.numAttributes()) {
            throw new IllegalArgumentException("Can't insert attribute: index out of range");
        }
        this.forceInsertAttributeAt(position);
    }

    public boolean isMissing(int attIndex) {
        return Double.isNaN(this.m_AttValues[attIndex]);
    }

    public boolean isMissingSparse(int indexOfIndex) {
        return Double.isNaN(this.m_AttValues[indexOfIndex]);
    }

    public boolean isMissing(AttributeWeka att) {
        return this.isMissing(att.index());
    }

    public static boolean isMissingValue(double val) {
        return Double.isNaN(val);
    }

    public Instance mergeInstance(Instance inst) {
        int m = 0;
        double[] newVals = new double[this.numAttributes() + inst.numAttributes()];
        int j = 0;
        while (j < this.numAttributes()) {
            newVals[m] = this.value(j);
            ++j;
            ++m;
        }
        j = 0;
        while (j < inst.numAttributes()) {
            newVals[m] = inst.value(j);
            ++j;
            ++m;
        }
        return new Instance(1.0, newVals);
    }

    public static double missingValue() {
        return Double.NaN;
    }

    public int numAttributes() {
        return this.m_AttValues.length;
    }

    public int numClasses() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.numClasses();
    }

    public int numValues() {
        return this.m_AttValues.length;
    }

    public void replaceMissingValues(double[] array) {
        if (array == null || array.length != this.m_AttValues.length) {
            throw new IllegalArgumentException("Unequal number of attributes!");
        }
        this.freshAttributeVector();
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            if (!this.isMissing(i)) continue;
            this.m_AttValues[i] = array[i];
        }
    }

    public void setClassMissing() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setMissing(this.classIndex());
    }

    public void setClassValue(double value) {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setValue(this.classIndex(), value);
    }

    public final void setClassValue(String value) {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setValue(this.classIndex(), value);
    }

    public final void setDataset(Instances instances) {
        this.m_Dataset = instances;
    }

    public final void setMissing(int attIndex) {
        this.setValue(attIndex, Double.NaN);
    }

    public final void setMissing(AttributeWeka att) {
        this.setMissing(att.index());
    }

    public void setValue(int attIndex, double value) {
        this.freshAttributeVector();
        this.m_AttValues[attIndex] = value;
    }

    public void setValueSparse(int indexOfIndex, double value) {
        this.freshAttributeVector();
        this.m_AttValues[indexOfIndex] = value;
    }

    public final void setValue(int attIndex, String value) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        if (!this.attribute(attIndex).isNominal() && !this.attribute(attIndex).isString()) {
            throw new IllegalArgumentException("AttributeWeka neither nominal nor string!");
        }
        int valIndex = this.attribute(attIndex).indexOfValue(value);
        if (valIndex == -1) {
            if (this.attribute(attIndex).isNominal()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            this.attribute(attIndex).forceAddValue(value);
            valIndex = this.attribute(attIndex).indexOfValue(value);
        }
        this.setValue(attIndex, (double)valIndex);
    }

    public final void setValue(AttributeWeka att, double value) {
        this.setValue(att.index(), value);
    }

    public final void setValue(AttributeWeka att, String value) {
        if (!att.isNominal() && !att.isString()) {
            throw new IllegalArgumentException("AttributeWeka neither nominal nor string!");
        }
        int valIndex = att.indexOfValue(value);
        if (valIndex == -1) {
            if (att.isNominal()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            att.forceAddValue(value);
            valIndex = att.indexOfValue(value);
        }
        this.setValue(att.index(), (double)valIndex);
    }

    public void modifyValue(int attIndex, double value) {
        this.m_AttValues[attIndex] = value;
    }

    public final void setWeight(double weight) {
        this.m_Weight = weight;
    }

    public final Instances relationalValue(int attIndex) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.relationalValue(this.m_Dataset.attribute(attIndex));
    }

    public final Instances relationalValue(AttributeWeka att) {
        int attIndex = att.index();
        if (att.isRelationValued()) {
            return att.relation((int)this.value(attIndex));
        }
        throw new IllegalArgumentException("AttributeWeka isn't relation-valued!");
    }

    public final String stringValue(int attIndex) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.stringValue(this.m_Dataset.attribute(attIndex));
    }

    public final String stringValue(AttributeWeka att) {
        int attIndex = att.index();
        switch (att.type()) {
            case 1: 
            case 2: {
                return att.value((int)this.value(attIndex));
            }
            case 3: {
                return att.formatDate(this.value(attIndex));
            }
            case 4: {
                return att.relation((int)this.value(attIndex)).stringWithoutHeader();
            }
        }
        throw new IllegalArgumentException("AttributeWeka isn't nominal, string or date!");
    }

    public double[] toDoubleArray() {
        double[] newValues = new double[this.m_AttValues.length];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, this.m_AttValues.length);
        return newValues;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            if (i > 0) {
                text.append(",");
            }
            text.append(this.toString(i));
        }
        if (this.m_Weight != 1.0) {
            text.append(",{" + Utils.doubleToString(this.m_Weight, 6) + "}");
        }
        return text.toString();
    }

    public final String toString(int attIndex) {
        StringBuffer text = new StringBuffer();
        if (this.isMissing(attIndex)) {
            text.append("?");
        } else if (this.m_Dataset == null) {
            text.append(Utils.doubleToString(this.m_AttValues[attIndex], 6));
        } else {
            switch (this.m_Dataset.attribute(attIndex).type()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    text.append(Utils.quote(this.stringValue(attIndex)));
                    break;
                }
                case 0: {
                    text.append(Utils.doubleToString(this.value(attIndex), 6));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown attribute type");
                }
            }
        }
        return text.toString();
    }

    public final String toString(AttributeWeka att) {
        return this.toString(att.index());
    }

    public double value(int attIndex) {
        return this.m_AttValues[attIndex];
    }

    public double valueSparse(int indexOfIndex) {
        return this.m_AttValues[indexOfIndex];
    }

    public double value(AttributeWeka att) {
        return this.value(att.index());
    }

    public final double weight() {
        return this.m_Weight;
    }

    void forceDeleteAttributeAt(int position) {
        double[] newValues = new double[this.m_AttValues.length - 1];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, position);
        if (position < this.m_AttValues.length - 1) {
            System.arraycopy(this.m_AttValues, position + 1, newValues, position, this.m_AttValues.length - (position + 1));
        }
        this.m_AttValues = newValues;
    }

    void forceInsertAttributeAt(int position) {
        double[] newValues = new double[this.m_AttValues.length + 1];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, position);
        newValues[position] = Double.NaN;
        System.arraycopy(this.m_AttValues, position, newValues, position + 1, this.m_AttValues.length - position);
        this.m_AttValues = newValues;
    }

    protected Instance() {
    }

    private void freshAttributeVector() {
        this.m_AttValues = this.toDoubleArray();
    }
}

