/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.binarray;

import net.sourceforge.jclec.ISpecies;
import net.sourceforge.jclec.base.AbstractCreator;
import net.sourceforge.jclec.binarray.BinArraySpecies;

public class BinArrayCreator
extends AbstractCreator {
    private static final long serialVersionUID = -2638928425169895614L;
    protected transient BinArraySpecies species;
    protected transient byte[] schema;

    public boolean equals(Object other) {
        return other instanceof BinArrayCreator;
    }

    @Override
    protected void prepareCreation() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof BinArraySpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (BinArraySpecies)spc;
        this.schema = this.species.getGenotypeSchema();
    }

    @Override
    protected void createNext() {
        this.createdBuffer.add(this.species.createIndividual(this.createGenotype()));
    }

    private final byte[] createGenotype() {
        int gl = this.schema.length;
        byte[] result = new byte[gl];
        int i = 0;
        while (i < gl) {
            result[i] = this.schema[i] == -1 ? (byte)this.randgen.choose(0, 2) : this.schema[i];
            ++i;
        }
        return result;
    }
}

