/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.Difuso;
import org.core.Fichero;

public class BaseD {
    int n_variables;
    int n_etiquetas;
    Difuso[][] baseDatos;
    Difuso[][] baseDatosIni;

    public BaseD() {
    }

    public BaseD(int n_etiquetas, int n_variables, double[][] rangos) {
        this.n_variables = n_variables;
        this.n_etiquetas = n_etiquetas;
        this.baseDatos = new Difuso[n_variables][n_etiquetas];
        this.baseDatosIni = new Difuso[n_variables][n_etiquetas];
        for (int i = 0; i < n_variables; ++i) {
            double marca = (rangos[i][1] - rangos[i][0]) / (double)((float)n_etiquetas - 1.0f);
            for (int etq = 0; etq < n_etiquetas; ++etq) {
                double valor = rangos[i][0] + marca * (double)(etq - 1);
                this.baseDatos[i][etq] = new Difuso();
                this.baseDatos[i][etq].x0 = this.Asigna(valor, rangos[i][1]);
                valor = rangos[i][0] + marca * (double)etq;
                this.baseDatos[i][etq].x1 = this.baseDatos[i][etq].x2 = this.Asigna(valor, rangos[i][1]);
                valor = rangos[i][0] + marca * (double)(etq + 1);
                this.baseDatos[i][etq].x3 = this.Asigna(valor, rangos[i][1]);
                this.baseDatos[i][etq].y = 1.0;
                this.baseDatos[i][etq].nombre = new String("L" + etq);
                this.baseDatos[i][etq].etiqueta = etq;
                this.baseDatosIni[i][etq] = new Difuso();
                this.baseDatosIni[i][etq].x0 = this.Asigna(valor, rangos[i][1]);
                valor = rangos[i][0] + marca * (double)etq;
                this.baseDatosIni[i][etq].x1 = this.baseDatosIni[i][etq].x2 = this.Asigna(valor, rangos[i][1]);
                valor = rangos[i][0] + marca * (double)(etq + 1);
                this.baseDatosIni[i][etq].x3 = this.Asigna(valor, rangos[i][1]);
                this.baseDatosIni[i][etq].y = 1.0;
                this.baseDatosIni[i][etq].nombre = new String("L" + etq);
                this.baseDatosIni[i][etq].etiqueta = etq;
            }
        }
    }

    private double Asigna(double val, double tope) {
        if (val > -1.0E-4 && val < 1.0E-4) {
            return 0.0;
        }
        if (val > tope - 1.0E-4 && val < tope + 1.0E-4) {
            return tope;
        }
        return val;
    }

    public int numVariables() {
        return this.n_variables;
    }

    public double pertenencia(int i, int j, double X) {
        return this.baseDatos[i][j].Fuzzifica(X);
    }

    public Difuso copia(int i, int j) {
        return this.baseDatos[i][j].clone();
    }

    public String printString() {
        String cadena = new String("");
        for (int i = 0; i < this.n_variables; ++i) {
            cadena = cadena + "\nVariable " + (i + 1) + ":\n";
            for (int j = 0; j < this.n_etiquetas; ++j) {
                cadena = cadena + " Label " + (j + 1) + ": (" + this.baseDatos[i][j].x0 + "," + this.baseDatos[i][j].x1 + "," + this.baseDatos[i][j].x3 + ")\n";
            }
        }
        return cadena;
    }

    public void escribeFichero(String filename) {
        String cadenaSalida = new String("");
        cadenaSalida = this.printString();
        Fichero.escribeFichero(filename, cadenaSalida);
    }

    public int dameEtiqueta(int variable, double valor) {
        int i = 0;
        while (valor != this.baseDatos[variable][i].x0) {
            ++i;
        }
        return i;
    }

    public BaseD clone() {
        BaseD base = new BaseD();
        base.n_etiquetas = this.n_etiquetas;
        base.n_variables = this.n_variables;
        base.baseDatos = new Difuso[this.n_variables][this.n_etiquetas];
        for (int i = 0; i < this.n_variables; ++i) {
            for (int j = 0; j < this.n_etiquetas; ++j) {
                base.baseDatos[i][j] = this.copia(i, j);
            }
        }
        return base;
    }

    public void ponBaseDatosInicial() {
        for (int i = 0; i < this.n_variables; ++i) {
            for (int j = 0; j < this.n_etiquetas; ++j) {
                this.baseDatos[i][j] = this.baseDatosIni[i][j].clone();
            }
        }
    }

    public void ajusta(double[] cromosoma) {
        this.ponBaseDatosInicial();
        int k = 0;
        for (int i = 0; i < this.n_variables; ++i) {
            for (int j = 0; j < this.n_etiquetas; ++j) {
                this.baseDatos[i][j].x0 = cromosoma[k];
                this.baseDatos[i][j].x1 = cromosoma[k + 1];
                this.baseDatos[i][j].x3 = cromosoma[k + 2];
                k += 3;
            }
        }
    }
}

