/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA;

import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.Item;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.Itemset;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.Rule;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFCRA.myDataset;
import org.core.Files;

public class RuleBase {
    ArrayList<Rule> ruleBase;
    DataBase dataBase;
    myDataset train;
    int n_variables;
    double fitness;

    public boolean BETTER(int a, int b) {
        return a > b;
    }

    public RuleBase() {
    }

    public RuleBase(DataBase dataBase, myDataset train) {
        this.ruleBase = new ArrayList();
        this.dataBase = dataBase;
        this.train = train;
        this.n_variables = dataBase.numVariables();
        this.fitness = 0.0;
    }

    public RuleBase clone() {
        RuleBase br = new RuleBase();
        br.ruleBase = new ArrayList();
        for (int i = 0; i < this.ruleBase.size(); ++i) {
            br.ruleBase.add(this.ruleBase.get(i).clone());
        }
        br.dataBase = this.dataBase;
        br.train = this.train;
        br.n_variables = this.n_variables;
        br.fitness = this.fitness;
        return br;
    }

    public void add(Rule rule) {
        this.ruleBase.add(rule);
    }

    public void add(Itemset itemset) {
        int i;
        int[] antecedent = new int[this.n_variables];
        for (i = 0; i < this.n_variables; ++i) {
            antecedent[i] = -1;
        }
        for (i = 0; i < itemset.size(); ++i) {
            Item item = itemset.get(i);
            antecedent[item.getVariable()] = item.getValue();
        }
        Rule r = new Rule(this.dataBase);
        r.asignaAntecedente(antecedent);
        r.setConsequent(itemset.getClas());
        r.setConfidence(itemset.getSupportClass() / itemset.getSupport());
        r.setSupport(itemset.getSupportClass());
        this.ruleBase.add(r);
    }

    public Rule get(int pos) {
        return this.ruleBase.get(pos);
    }

    public int size() {
        return this.ruleBase.size();
    }

    public void sort() {
        Collections.sort(this.ruleBase);
    }

    public Rule remove(int pos) {
        return this.ruleBase.remove(pos);
    }

    public double evaluate() {
        int nHits = 0;
        for (int j = 0; j < this.train.size(); ++j) {
            int Prediction = this.FRM_WR(this.train.getExample(j));
            if (this.train.getOutputAsInteger(j) != Prediction) continue;
            ++nHits;
        }
        this.fitness = 100.0 * (double)nHits / (1.0 * (double)this.train.size());
        return this.fitness;
    }

    public int FRM(double[] example) {
        return this.FRM_WR(example);
    }

    private int FRM_WR(double[] example) {
        int clas = -1;
        double max = 0.0;
        for (int i = 0; i < this.ruleBase.size(); ++i) {
            Rule r = this.ruleBase.get(i);
            double DF = r.matching(example);
            if (!(DF > max)) continue;
            max = DF;
            clas = r.getClas();
        }
        return clas;
    }

    public double getAccuracy() {
        return this.fitness;
    }

    public void reduceRules() {
        this.sort();
        for (int i = 0; i < this.ruleBase.size(); ++i) {
            Rule rulei = this.ruleBase.get(i);
            for (int j = i + 1; j < this.ruleBase.size(); ++j) {
                Rule rulej = this.ruleBase.get(j);
                if (!rulei.isSubset(rulej)) continue;
                this.ruleBase.remove(j);
                --j;
            }
        }
    }

    public void adaptiveRules(double n1, double n2, int Jmax) {
        for (int i = 0; i < Jmax; ++i) {
            for (int j = 0; j < this.train.size(); ++j) {
                Rule r;
                double max = -1.0;
                int bestRule = -1;
                for (int k = 0; k < this.ruleBase.size(); ++k) {
                    r = this.ruleBase.get(k);
                    double DF = r.matching(this.train.getExample(j));
                    if (!(DF > max)) continue;
                    max = DF;
                    bestRule = k;
                }
                if (bestRule <= -1) continue;
                r = this.ruleBase.get(bestRule);
                double conf = r.getConfidence();
                if (this.train.getOutputAsInteger(j) == r.getClas()) {
                    r.setConfidence(conf + n1 * (1.0 - conf));
                    continue;
                }
                r.setConfidence(conf - n2 * conf);
            }
        }
    }

    public String printString() {
        int i;
        String[] names = this.train.names();
        String[] clases = this.train.clases();
        String stringOut = new String("");
        int ant = 0;
        for (i = 0; i < this.ruleBase.size(); ++i) {
            int j;
            Rule r = this.ruleBase.get(i);
            stringOut = stringOut + (i + 1) + ": ";
            for (j = 0; j < this.n_variables && r.antecedent[j] < 0; ++j) {
            }
            if (j < this.n_variables && r.antecedent[j] >= 0) {
                stringOut = stringOut + names[j] + " IS " + r.dataBase.print(j, r.antecedent[j]);
                ++ant;
            }
            ++j;
            while (j < this.n_variables - 1) {
                if (r.antecedent[j] >= 0) {
                    stringOut = stringOut + " AND " + names[j] + " IS " + r.dataBase.print(j, r.antecedent[j]);
                    ++ant;
                }
                ++j;
            }
            if (j < this.n_variables && r.antecedent[j] >= 0) {
                stringOut = stringOut + " AND " + names[j] + " IS " + r.dataBase.print(j, r.antecedent[j]) + ": " + clases[r.clas];
                ++ant;
            } else {
                stringOut = stringOut + ": " + clases[r.clas];
            }
            stringOut = stringOut + " CF: " + r.getConfidence() + "\n";
        }
        stringOut = stringOut + "\n\n";
        stringOut = stringOut + "@supp and CF:\n\n";
        for (i = 0; i < this.ruleBase.size(); ++i) {
            Rule rule = this.ruleBase.get(i);
            stringOut = stringOut + (i + 1) + ": ";
            stringOut = stringOut + "supp: " + rule.getSupport() + " AND CF: " + rule.getConfidence() + "\n";
        }
        stringOut = "@Number of rules: " + this.ruleBase.size() + " Number of Antecedents by rule: " + (double)ant * 1.0 / (double)this.ruleBase.size() + "\n\n" + stringOut;
        return stringOut;
    }

    public void saveFile(String filename, double minFS, double minFC) {
        String stringOut = new String("");
        stringOut = this.printString();
        stringOut = stringOut + "\n\n@Minimum Support: " + minFS + "  Minimum Confidence: " + minFC + "\n\n";
        Files.writeFile(filename, stringOut);
    }
}

