/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh.MOEA_GhoshProcess;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh.myDataset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh.parseParameters;
import keel.Dataset.Attributes;
import org.core.Files;
import org.core.Randomize;

public class MOEA_Ghosh {
    private myDataset dataset;
    private String rulesFilename;
    private String valuesFilename;
    private String paretoFilename;
    private String fileTime;
    private String fileHora;
    private String namedataset;
    private MOEA_GhoshProcess proc;
    private ArrayList<AssociationRule> associationRulesPareto;
    private int nTrials;
    private int popSize;
    private int pointCrossover;
    private int numObjectives;
    private double pc;
    private double pm;
    private double af;
    long startTime;
    long totalTime;
    private boolean somethingWrong = false;

    public MOEA_Ghosh() {
    }

    public MOEA_Ghosh(parseParameters parameters) {
        this.startTime = System.currentTimeMillis();
        this.dataset = new myDataset();
        try {
            this.namedataset = parameters.getTransactionsInputFile();
            System.out.println("\nReading the transaction set: " + parameters.getTransactionsInputFile());
            this.dataset.readDataSet(parameters.getTransactionsInputFile());
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input transaction set: " + e);
            this.somethingWrong = true;
        }
        this.somethingWrong = this.somethingWrong || this.dataset.hasMissingAttributes();
        this.rulesFilename = parameters.getAssociationRulesFile();
        this.valuesFilename = parameters.getOutputFile(0);
        this.paretoFilename = parameters.getOutputFile(1);
        this.fileTime = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/time.txt";
        this.fileHora = parameters.getOutputFile(1).substring(0, parameters.getOutputFile(1).lastIndexOf(47)) + "/hora.txt";
        long seed = Long.parseLong(parameters.getParameter(0));
        this.numObjectives = Integer.parseInt(parameters.getParameter(1));
        this.nTrials = Integer.parseInt(parameters.getParameter(2));
        this.popSize = Integer.parseInt(parameters.getParameter(3));
        this.pointCrossover = Integer.parseInt(parameters.getParameter(4));
        this.pc = Double.parseDouble(parameters.getParameter(5));
        this.pm = Double.parseDouble(parameters.getParameter(6));
        this.af = Double.parseDouble(parameters.getParameter(7));
        Randomize.setSeed(seed);
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found");
            System.err.println("Aborting the program");
        } else {
            this.proc = new MOEA_GhoshProcess(this.dataset, this.numObjectives, this.nTrials, this.popSize, this.pointCrossover, this.pc, this.pm, this.af);
            this.proc.run();
            this.associationRulesPareto = this.proc.generateRulesPareto();
            try {
                PrintWriter rules_writer = new PrintWriter(this.rulesFilename);
                PrintWriter values_writer = new PrintWriter(this.valuesFilename);
                PrintWriter pareto_writer = new PrintWriter(this.paretoFilename);
                rules_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                rules_writer.println("<association_rules>");
                values_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                values_writer.println("<values>");
                pareto_writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                pareto_writer.println("<values>");
                for (int r = 0; r < this.associationRulesPareto.size(); ++r) {
                    Gene gen;
                    int i;
                    AssociationRule a_r = this.associationRulesPareto.get(r);
                    ArrayList<Gene> ant = a_r.getAntecedents();
                    ArrayList<Gene> cons = a_r.getConsequents();
                    rules_writer.println("<rule id=\"" + r + "\">");
                    values_writer.println("<rule id=\"" + r + "\" rule_support=\"" + MOEA_GhoshProcess.roundDouble(a_r.getSupport(), 2) + "\" antecedent_support=\"" + MOEA_GhoshProcess.roundDouble(a_r.getAntSupport(), 2) + "\" consequent_support=\"" + MOEA_GhoshProcess.roundDouble(a_r.getConsSupport(), 2) + "\" confidence=\"" + MOEA_GhoshProcess.roundDouble(a_r.getConfidence(), 2) + "\" lift=\"" + MOEA_GhoshProcess.roundDouble(a_r.getLift(), 2) + "\" conviction=\"" + MOEA_GhoshProcess.roundDouble(a_r.getConv(), 2) + "\" certainFactor=\"" + MOEA_GhoshProcess.roundDouble(a_r.getCF(), 2) + "\" netConf=\"" + MOEA_GhoshProcess.roundDouble(a_r.getNetConf(), 2) + "\" yulesQ=\"" + MOEA_GhoshProcess.roundDouble(a_r.getYulesQ(), 2) + "\" nAttributes=\"" + (a_r.getnAnts() + a_r.getConsequents().size()) + "\"/>");
                    rules_writer.println("<antecedents>");
                    for (i = 0; i < ant.size(); ++i) {
                        gen = ant.get(i);
                        this.createRule(gen, gen.getAttr(), rules_writer);
                    }
                    rules_writer.println("</antecedents>");
                    rules_writer.println("<consequents>");
                    for (i = 0; i < cons.size(); ++i) {
                        gen = cons.get(i);
                        this.createRule(gen, gen.getAttr(), rules_writer);
                    }
                    rules_writer.println("</consequents>");
                    rules_writer.println("</rule>");
                }
                rules_writer.println("</association_rules>");
                values_writer.println("</values>");
                rules_writer.close();
                values_writer.close();
                pareto_writer.print(this.proc.getParetos());
                pareto_writer.println("</values>");
                pareto_writer.close();
                this.totalTime = System.currentTimeMillis() - this.startTime;
                this.writeTime();
                System.out.println("Algorithm Finished");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeTime() {
        String stringOut = new String("");
        stringOut = "" + this.totalTime / 1000L + "  " + this.namedataset + this.rulesFilename + "\n";
        Files.addToFile(this.fileTime, stringOut);
        this.totalTime /= 1000L;
        long seg = this.totalTime % 60L;
        this.totalTime /= 60L;
        long min = this.totalTime % 60L;
        long hor = this.totalTime / 60L;
        stringOut = "";
        stringOut = hor < 10L ? stringOut + "0" + hor + ":" : stringOut + hor + ":";
        stringOut = min < 10L ? stringOut + "0" + min + ":" : stringOut + min + ":";
        stringOut = seg < 10L ? stringOut + "0" + seg : stringOut + seg;
        stringOut = stringOut + "  " + this.rulesFilename + "\n";
        Files.addToFile(this.fileHora, stringOut);
    }

    private void createRule(Gene g, int id_attr, PrintWriter w) {
        w.println("<attribute name=\"" + Attributes.getAttribute(id_attr).getName() + "\" value=\"");
        if (g.getOperator() == 2) {
            w.print("MAJOR ");
        }
        if (g.getOperator() == 1) {
            w.print("MINOR ");
        }
        if (g.getOperator() == 3) {
            w.print("EQUAL ");
        }
        if (g.getOperator() == 4) {
            w.print("UNEQUAL ");
        }
        if (this.dataset.getAttributeType(id_attr) == 0) {
            w.print(Attributes.getAttribute(id_attr).getNominalValue((int)g.getValue()));
        } else {
            w.print(g.getValue());
        }
        w.print("\" />");
    }
}

