/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.MCOD;

import java.util.Set;
import moa.clusterers.outliers.MCOD.MicroCluster;
import moa.clusterers.outliers.utils.mtree.ComposedSplitFunction;
import moa.clusterers.outliers.utils.mtree.DistanceFunction;
import moa.clusterers.outliers.utils.mtree.DistanceFunctions;
import moa.clusterers.outliers.utils.mtree.MTree;
import moa.clusterers.outliers.utils.mtree.PartitionFunctions;
import moa.clusterers.outliers.utils.mtree.PromotionFunction;
import moa.clusterers.outliers.utils.mtree.utils.Pair;
import moa.clusterers.outliers.utils.mtree.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MTreeMicroClusters
extends MTree<MicroCluster> {
    private static final PromotionFunction<MicroCluster> nonRandomPromotion = new PromotionFunction<MicroCluster>(){

        @Override
        public Pair<MicroCluster> process(Set<MicroCluster> dataSet, DistanceFunction<? super MicroCluster> distanceFunction) {
            return Utils.minMax(dataSet);
        }
    };

    MTreeMicroClusters() {
        super(2, DistanceFunctions.EUCLIDEAN, new ComposedSplitFunction<MicroCluster>(nonRandomPromotion, new PartitionFunctions.BalancedPartition()));
    }

    @Override
    public void add(MicroCluster data) {
        super.add(data);
        this._check();
    }

    @Override
    public boolean remove(MicroCluster data) {
        boolean result = super.remove(data);
        this._check();
        return result;
    }

    DistanceFunction<? super MicroCluster> getDistanceFunction() {
        return this.distanceFunction;
    }
}

