/*
 * Decompiled with CFR 0.152.
 */
package moa.recommender.predictor;

import java.util.List;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import moa.recommender.data.RecommenderData;
import moa.recommender.predictor.RatingPredictor;
import moa.tasks.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BRISMFPredictor
extends AbstractOptionHandler
implements RatingPredictor {
    protected moa.recommender.rc.predictor.impl.BRISMFPredictor rp;
    public IntOption featuresOption = new IntOption("features", 'f', "How many features to use.", 20, 0, Integer.MAX_VALUE);
    public FloatOption lRateOption = new FloatOption("lRate", 'r', "lRate", 0.001);
    public FloatOption rFactorOption = new FloatOption("rFactor", 'a', "rFactor", 0.01);
    public IntOption iterationsOption = new IntOption("iterations", 'i', "How many iterations to use.", 100, 0, Integer.MAX_VALUE);
    public ClassOption dataOption = new ClassOption("data", 'd', "Data", RecommenderData.class, "moa.recommender.data.MemRecommenderData");

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        RecommenderData data = (RecommenderData)this.getPreparedClassOption(this.dataOption);
        this.rp = new moa.recommender.rc.predictor.impl.BRISMFPredictor(this.featuresOption.getValue(), data.getData(), this.lRateOption.getValue(), this.rFactorOption.getValue(), false);
        this.rp.setNIterations(this.iterationsOption.getValue());
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        sb.append(this.rp.toString());
    }

    public double predictRating(Integer user, Integer item) {
        return this.rp.predictRating(user, item);
    }

    @Override
    public moa.recommender.rc.data.RecommenderData getData() {
        return this.rp.getData();
    }

    @Override
    public double predictRating(int userID, int itemID) {
        return this.rp.predictRating(userID, itemID);
    }

    @Override
    public List<Double> predictRatings(int userID, List<Integer> itemIDS) {
        return this.rp.predictRatings(userID, itemIDS);
    }

    @Override
    public void train() {
        this.rp.train();
    }
}

