/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.graph.GraphView;

public class GraphSaveDialog
extends JDialog
implements ActionListener {
    JButton ok = new JButton("Ok");
    GraphView control;
    JTextField jt = new JTextField("", 30);
    JCheckBox savePvalues = new JCheckBox("Save p-values");
    JCheckBox saveCorrelation = new JCheckBox("Save test information / correlation");

    public GraphSaveDialog(GraphView control, String name) {
        super(control.getMainFrame(), "R object name", true);
        this.setLocationRelativeTo(control.getMainFrame());
        this.control = control;
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.jt.setText(name);
        this.jt.addActionListener(this);
        this.getContentPane().add((Component)new JLabel("R object name:"), cc.xy(2, row));
        this.getContentPane().add((Component)this.jt, cc.xyw(4, row, 3));
        this.getContentPane().add((Component)this.savePvalues, cc.xyw(2, row += 2, 3));
        this.savePvalues.setSelected(Configuration.getInstance().getBooleanClassProperty(GraphSaveDialog.class, "savePvalues", false));
        this.getContentPane().add((Component)this.saveCorrelation, cc.xyw(2, row += 2, 3));
        this.saveCorrelation.setSelected(Configuration.getInstance().getBooleanClassProperty(GraphSaveDialog.class, "saveCorrelation", false));
        this.getContentPane().add((Component)this.ok, cc.xy(6, row += 2));
        this.ok.addActionListener(this);
        this.actionPerformed(null);
        this.pack();
        this.setVisible(true);
    }

    public GraphSaveDialog(GraphView control) {
        this(control, Configuration.getInstance().getClassProperty(GraphSaveDialog.class, "variableName", ""));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Configuration.getInstance().setClassProperty(GraphSaveDialog.class, "variableName", this.jt.getText());
        Configuration.getInstance().setBooleanClassProperty(GraphSaveDialog.class, "saveCorrelation", this.saveCorrelation.isSelected());
        Configuration.getInstance().setBooleanClassProperty(GraphSaveDialog.class, "savePvalues", this.savePvalues.isSelected());
        this.dispose();
    }

    public void saveGraph() {
        String name = this.control.getNL().saveGraph(this.getName(), true, true, this.savePvalues.isSelected(), this.saveCorrelation.isSelected());
        Configuration.getInstance().getGeneralConfig().addGraph("R Object: " + name);
        this.control.isGraphSaved = true;
    }

    @Override
    public String getName() {
        return this.jt.getText();
    }

    public boolean attachPValues() {
        return this.savePvalues.isSelected();
    }

    public boolean attachCorrMat() {
        return this.saveCorrelation.isSelected();
    }
}

