## ----echo=FALSE, include=FALSE------------------------------------------------------------------------------------------
opts_chunk$set(opts_fig_wide)
opts_knit$set(concordance=TRUE)
opts_knit$set(unnamed.chunk.label = 'container-chunk')


## ----lists-0------------------------------------------------------------------------------------------------------------
lst1 <- list(x = 1:3, y = "ab", z = c(TRUE, FALSE))


## ----lists-0a-----------------------------------------------------------------------------------------------------------
str(lst1)
names(lst1)


## ----list-empty-faq-----------------------------------------------------------------------------------------------------
list()


## ----lists-1a-----------------------------------------------------------------------------------------------------------
lst1["x"]
lst1[1]
lst1[c(1, 3)]


## ----lists-1ay----------------------------------------------------------------------------------------------------------
lst1[-1]
lst1[c(-1, -3)]


## ----lists-1------------------------------------------------------------------------------------------------------------
lst1$x
lst1[["x"]]
lst1[[1]]


## ----index-partial-1----------------------------------------------------------------------------------------------------
lst1a <- list(abcd = 123, xyzw = 789)
lst1a[[1]]
lst1a[["abcd"]]
vct1 <- "abcd"
lst1a[[vct1]]


## ----index-partial-1a---------------------------------------------------------------------------------------------------
lst1a$abcd
lst1a$ab
lst1a$a


## ----lists-1az----------------------------------------------------------------------------------------------------------
is.vector(lst1[1])
is.list(lst1[1])
is.vector(lst1[[1]])
is.list(lst1[[1]])


## ----lists-1ax----------------------------------------------------------------------------------------------------------
lst1[[1]][3]


## ----lists-pg-01, eval=eval_playground----------------------------------------------------------------------------------
lst2 <- list()
lst2[["x"]] <- 1:3
lst2[["y"]] <- "ab"
lst2[["z"]] <- c(TRUE, FALSE)


## ----lists-pg-02, eval=eval_playground----------------------------------------------------------------------------------
lst2[["y"]] <- lst2[["x"]]


## ----lists-eb-xx>-------------------------------------------------------------------------------------------------------
list(a = 1, b = 2, c = 3)[-2]


## ----lists-1b-----------------------------------------------------------------------------------------------------------
lst3 <- append(lst1, list(yy = 1:10, zz = letters[5:1]), after = 2)
lst3


## ----lists-1c-----------------------------------------------------------------------------------------------------------
lst1$y <- NULL
lst1


## ----lists-1aa----------------------------------------------------------------------------------------------------------
print(lst1)
str(lst1)


## ----lists-2------------------------------------------------------------------------------------------------------------
lst4 <- list("a", "aa", 10)
lst5 <- list("b", TRUE)
lst6 <- list(A = lst4, B = lst5) # nested
str(lst6)


## ----lists-3------------------------------------------------------------------------------------------------------------
lst7 <- list(A = list("a", "aa", 10), B = list("b", TRUE))
str(lst7)


## ----lists-3s-----------------------------------------------------------------------------------------------------------
lst8 <- list(A = list("a", "aa", 10),
             B = list("b", TRUE),
             C = c(1, 3, 9),
             D = 4321)
str(lst8)


## ----lists-PG4, eval=eval_playground------------------------------------------------------------------------------------
LST9 <- list(A = list("a", "aa", "aaa"), B = list("b", "bb"))
# str(LST9)
LST9[2:1]
LST9[1]
LST9[[1]][2]
LST9[[1]][[2]]
LST9[2]
LST9[2][[1]]


## ----lists-EB1b---------------------------------------------------------------------------------------------------------
str(lst8, max.level = 1)


## ----lists-5------------------------------------------------------------------------------------------------------------
lst10 <- list(A = list("a", "aa", "aaa"), B = list("b", "bb"))
vct1 <- unlist(lst10)
vct1
is.list(lst10)
is.list(vct1)
mode(lst10)
mode(vct1)
names(lst10)
names(vct1)


## ----lists-6------------------------------------------------------------------------------------------------------------
str(vct1)
vct1[2]
vct1["A2"]


## ----lists-7------------------------------------------------------------------------------------------------------------
unname(vct1)
unname(lst10)


## ----lists-cleanup, include=FALSE---------------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----data-frames-0------------------------------------------------------------------------------------------------------
df1 <- data.frame(treatment = factor(rep(c("hot", "cold"), 3)),
                  height = c(10.2, 8.3, 12.0, 9.0, 11.2, 8.7),
                  weight = c(2.2, 3.3, 2.5, 2.8, 2.4, 3.0))
df1
colnames(df1)
rownames(df1)
str(df1)
class(df1)
mode(df1)
is.data.frame(df1)
is.list(df1)


## ----data-frames-0a-----------------------------------------------------------------------------------------------------
df2 <- data.frame(treatment = factor(c("hot", "cold")),
                  height = c(10.2, 8.3, 12.0, 9.0, 11.2, 8.7),
                  weight = c(2.2, 3.3, 2.5, 2.8, 2.4, 3.0))


## ----data-frames-1------------------------------------------------------------------------------------------------------
df1$height
df1[["height"]]
df1[[2]]
class(df1[["height"]])


## ----data-frames-2------------------------------------------------------------------------------------------------------
df1$x2 <- 6:1
df1[["x3"]] <- "b"
str(df1)


## ----data-frames-2a-----------------------------------------------------------------------------------------------------
LST1 <- list(x = 1:6, y = "a", z = c(TRUE, FALSE))
str(LST1)
LST1$x2 <- 6:1
LST1$x3 <- "b"
str(LST1)


## ----data-frame-empty-faq-----------------------------------------------------------------------------------------------
data.frame()


## ----data-frame-listof-faq----------------------------------------------------------------------------------------------
list(df1, df2)


## ----data-frame-add-co1l-faq--------------------------------------------------------------------------------------------
DF1 <- data.frame(A = 1:5, B = factor(5:1))
DF1[["C"]] <- 11:15
DF1


## ----data-frame-add-col2-faq--------------------------------------------------------------------------------------------
DF2 <- data.frame(A = 1:5, B = factor(5:1))
cbind(C = 11:15, DF2)


## ----data-frames-bx-03--------------------------------------------------------------------------------------------------
df1[2:3, 1:2]


## ----data-frames-3------------------------------------------------------------------------------------------------------
# first column, df1[[1]] preferred
df1[ , 1]
# first column, df1[["x"]] or df1$x preferred
df1[ , "treatment"]
# first row
df1[1, ]
# first two rows of the third and fourth columns
df1[1:2, c(FALSE, FALSE, TRUE, TRUE, FALSE)]
# the rows for which comparison is true
df1[df1$treatment == "hot" , ]
# the heights > 8
df1[df1$height > 8, "height"]


## ----data-frames-3a-----------------------------------------------------------------------------------------------------
df1[1, 2] <- 99
df1
df1[ , 2] <- -99
df1
df1[["height"]] <- c(10, 12)
df1
df1[1, 2] <- df1[6, 3]
df1
df1[3:6, 2] <- df1[6, 3]
df1


## ----data-frames-2b-----------------------------------------------------------------------------------------------------
is.data.frame(df1[1, ])
is.data.frame(df1[ , 2])
is.data.frame(df1[ , "treatment"])
is.data.frame(df1[1:2, 2:3])
is.vector(df1[1, ])
is.vector(df1[ , 2])
is.factor(df1[ , "treatment"])
is.vector(df1[1:2, 2:3])


## ----data-frames-2bb----------------------------------------------------------------------------------------------------
is.data.frame(df1[ , 1, drop = FALSE])
is.data.frame(df1[ , "treatment", drop = FALSE])


## ----data-frames-bx-constr-01-------------------------------------------------------------------------------------------
vct1 <- c(one = 1, two = 2, three = 3, four = 4)
fct1 <- as.factor(c(1, 2, 3, 2))
df1 <- data.frame(fct1, vct1)
df1
df1$vct1


## ----data-frames-bx-constr-02-------------------------------------------------------------------------------------------
df2 <- data.frame(fct1, I(vct1))
df2
df2$vct1


## ----data-frames-bx-constr-04-------------------------------------------------------------------------------------------
mat1 <- matrix(1:12, ncol = 3)
df4 <- data.frame(fct1, mat1)


## ----data-frames-bx-constr-04a------------------------------------------------------------------------------------------
df4


## ----data-frames-bx-constr-05-------------------------------------------------------------------------------------------
df5 <- data.frame(fct1, I(mat1))
df5
df5$mat1


## ----data-frames-bx-constr-06-------------------------------------------------------------------------------------------
lst1 <- list(a = 4:1, b = letters[4:1], c = "n", d = "z")
df6<- data.frame(fct1, lst1)
df6


## ----data-frames-bx-constr-07-------------------------------------------------------------------------------------------
df7<- data.frame(fct1, I(lst1))
df7

## ----data-frames-bx-constr-07b------------------------------------------------------------------------------------------
df7$lst1


## ----data-frames-4------------------------------------------------------------------------------------------------------
df8 <- data.frame(x = 1:6, y = "a", z = c(TRUE, FALSE))
subset(df8, x > 3)


## ----data-frames-5------------------------------------------------------------------------------------------------------
subset(df8, x > 3)[ , -3]
subset(df8, x > 3)[ , "x", drop = FALSE]
subset(df8, x > 3)[ , "x"]


## ----data-frames-5aa----------------------------------------------------------------------------------------------------
subset(df8, x > 3, select = 2)


## ----data-frames-5ab----------------------------------------------------------------------------------------------------
subset(df8, x > 3, select = x)


## ----data-frames-5ac----------------------------------------------------------------------------------------------------
subset(df8, x > 3, select = "x")


## ----data-frames-5b-----------------------------------------------------------------------------------------------------
A <- 1
subset(df8, A > 3)


## ----data-frames-5c-----------------------------------------------------------------------------------------------------
columns <- c("x", "z")
subset(df8, select = columns)


## ----data-frames-6------------------------------------------------------------------------------------------------------
df9 <- df8
head(df9)
df9[["y"]] <- NULL
head(df9)


## ----data-frames-6a-----------------------------------------------------------------------------------------------------
df8[ , -which(colnames(df8) == "y")]


## ----data-frames-7, eval=eval_playground--------------------------------------------------------------------------------
df8[1:6, c(1,3)] <- df8[6:1, c(3,1)]
df8


## ----data-frames-7aaa---------------------------------------------------------------------------------------------------
summary(df8)


## ----data-frames-7aa----------------------------------------------------------------------------------------------------
df10 <- data.frame(x1 = 1:6, x2 = c(1, 5, 4, 2, 6, 3), z = c("a", "b"))


## ----data-frames-7a-----------------------------------------------------------------------------------------------------
split(df10, df10$z)


## ----data-frames-7c-----------------------------------------------------------------------------------------------------
split(df10, ~ z)


## ----faq-aggregate-01---------------------------------------------------------------------------------------------------
aggregate(x = iris$Petal.Length,
          by = list(iris$Species), FUN = mean)


## ----faq-aggregate-02---------------------------------------------------------------------------------------------------
aggregate(x = iris[ , sapply(iris, is.numeric)],
          by = list(iris$Species), FUN = mean)


## ----data-frames-7d-----------------------------------------------------------------------------------------------------
aggregate(x1 ~ z, FUN = mean, data = df10)


## ----data-frames-7e-----------------------------------------------------------------------------------------------------
aggregate(cbind(x1, x2) ~ z, FUN = mean, data = df10)


## ----data-frames-7f-----------------------------------------------------------------------------------------------------
aggregate(. ~ z, FUN = mean, data = df10)


## ----data-frames-8------------------------------------------------------------------------------------------------------
df11 <- data.frame(A = 1:10, B = 3, C = c("A", "B"))
head(df11, 2)
df11 <- df11[ , c("B", "A", "C")]
head(df11, 2)


## ----data-frames-8ax----------------------------------------------------------------------------------------------------
df11 <- data.frame(A = 1:10, B = 3, C = c("A", "B"))
head(df11, 2)
df11[ , 1:2] <- df11[ , 2:1]
head(df11, 2)
colnames(df11)[1:2] <- colnames(df11)[2:1]
head(df11, 2)


## ----faq-data-frames-01-------------------------------------------------------------------------------------------------
sorted_cols_iris <- iris[ , sort(colnames(iris), decreasing = TRUE)]
head(sorted_cols_iris, 5)


## ----faq-data-frames-02-------------------------------------------------------------------------------------------------
sorted_rows_iris <- iris[order(iris$Petal.Length), ]
head(sorted_rows_iris, 5)


## ----data-frames-9------------------------------------------------------------------------------------------------------
df12 <-
  data.frame(genotype = rep(c("WT", "mutant1", "mutant2"), 2),
             value = c(1.5, 3.2, 4.5, 8.2, 7.4, 6.2))
mutant <- c(WT = FALSE, mutant1 = TRUE, mutant2 = TRUE)
df12$mutant <- mutant[df12$genotype]
df12


## ----data-frames-10-----------------------------------------------------------------------------------------------------
df13 <- data.frame(individual = rep(1:3, 2),
                   value = c(1.5, 3.2, 4.5, 8.2, 7.4, 6.2))
genotype <- c("WT", "mutant1", "mutant2")
df13$genotype <- genotype[df13$individual]
df13


## ----data-frames-11, eval=eval_playground-------------------------------------------------------------------------------
DF1 <- data.frame(individual = rep(c(2, 4, 1), 2),
                  value = c(1.5, 3.2, 4.5, 8.2, 7.4, 6.2))


## ----data-frames-EB-12--------------------------------------------------------------------------------------------------
df14 <- data.frame(A = 1:10, B = 3)
df14$C <- with(df14, (A + B) / A) # add column
head(df14, 3)


## ----data-frames-EB-13--------------------------------------------------------------------------------------------------
df14$C <- NULL
df15 <- within(df14,  C <- (A + B) / A) # midified copy
head(df15, 3)


## ----data-frames-EB-14--------------------------------------------------------------------------------------------------
df16 <- within(df14,
               {C <- (A + B) / A
                D <- A * B
                E <- A / B + 1}
               )
head(df16, 3)


## ----data-frames-EB-10--------------------------------------------------------------------------------------------------
df14$C <- (df14$A + df14$B) / df14$A
df14$D <- df14$A * df14$B
df14$D <- df14$A / df14$B + 1
head(df14, 3)


## ----data-frames-EB-11a-------------------------------------------------------------------------------------------------
df17 <- data.frame(A = 1:10, B = 3)
A
attach(df17)
A
detach(df17)
A


## ----data-frames-EB-11--------------------------------------------------------------------------------------------------
attach(df17)
df17$C <- (A + B) / A
detach(df17)
head(df17, 2)


## ----include=FALSE------------------------------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----data-frames-reshape-01---------------------------------------------------------------------------------------------
# artifical data
df1 <- data.frame(id = rep(1:4, rep(2,4)),
                  Time = factor(rep(c("Before","After"), 4)),
                  Weight = rnorm(n = 4, mean = c(20.1, 30.8)),
                  Height = rnorm(n = 4, mean = c(9.5, 14.2)))
df1
# make it wider
df2 <- reshape(df1, timevar = "Time", idvar = "id", direction = "wide")
df2
# possible further calculation
within(df2,
       {
        Height.growth <- Height.After - Height.Before
        Weight.growth <- Weight.After - Weight.Before
       })


## ----data-frames-reshape-02---------------------------------------------------------------------------------------------
df1$ID <- rownames(df1) # unique ID for each row
# make it longer
reshape(df1,
        idvar = "ID",
        timevar = "Quantity",
        times = c("Weight", "Height"),
        v.names = "Value",
        direction = "long",
        varying = c("Weight", "Height"))


## ----exploring-dfs-0a, eval=FALSE---------------------------------------------------------------------------------------
## View(cars)
## edit(cars)


## ----echo=FALSE,cache=FALSE---------------------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----attributes-00------------------------------------------------------------------------------------------------------
df1 <- data.frame(x = 1:6, y = c("a", "b"), z = c(TRUE, FALSE, NA))
df1
attributes(df1)
str(df1)


## ----attributes-01------------------------------------------------------------------------------------------------------
comment(df1)
comment(df1) <- "this is stored as a comment"
comment(df1)


## ----attributes-01a-----------------------------------------------------------------------------------------------------
attr(df1, "comment")
attr(df1, "comment") <- NULL
attr(df1, "comment")
comment(df1) # same as previous line


## ----attributes-02------------------------------------------------------------------------------------------------------
names(df1)
colnames(df1) # same as names()
colnames(df1) <- toupper(colnames(df1))
colnames(df1)
attr(df1, "names") # same as previous line


## ----attributes-names-ebx-01, eval=eval_playground----------------------------------------------------------------------
VCT1 <- 5:10
names(VCT1)
labels(VCT1)
names(VCT1) <- letters[5:10]
names(VCT1)
labels(VCT1)


## ----attibutes-names-ebx-02, eval=eval_playground-----------------------------------------------------------------------
MAT1 <- matrix(1:10, ncol = 2)
dimnames(MAT1)
labels(MAT1)
colnames(MAT1) <- c("a", "b")
colnames(MAT1)
dimnames(MAT1)
labels(MAT1)


## ----attributes-02a-----------------------------------------------------------------------------------------------------
attr(df1, "my.attribute") <- "this is stored in my attribute"
attributes(df1)


## ----attibutes-ebx-01a--------------------------------------------------------------------------------------------------
mat1 <- matrix(1:10, ncol = 2)
attributes(mat1)
dim(mat1)
dimnames(mat1)


## ----attibutes-ebx-01aa-------------------------------------------------------------------------------------------------
labels(mat1)
mat1


## ----attibutes-ebx-01b--------------------------------------------------------------------------------------------------
attr(mat1, "dim")
attr(mat1, "dim") <- c(2, 5)
mat1


## ----attibutes-ebx-01c--------------------------------------------------------------------------------------------------
attr(mat1, "dim") <- NULL
is.vector(mat1 )
mat1


## ----attibutes-ebx-01d--------------------------------------------------------------------------------------------------
dim(mat1) <- NULL
is.vector(mat1 )


## ----include=FALSE------------------------------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----data-1-------------------------------------------------------------------------------------------------------------
data(cars)


## ----rda-01-------------------------------------------------------------------------------------------------------------
df1 <- data.frame(x = 1:5, y = 5:1)
df1
save(df1, file = "df1.rda")


## ----rda-02-------------------------------------------------------------------------------------------------------------
remove(df1)
objects(pattern = "df1")


## ----rda-03-------------------------------------------------------------------------------------------------------------
load(file = "df1.rda")
objects(pattern = "df1")
df1


## ----rda-04-------------------------------------------------------------------------------------------------------------
dfs <- objects(pattern = "*.df")
save(list = dfs, file = "my-dfs.rda")


## ----rda-05-------------------------------------------------------------------------------------------------------------
save(list = objects(pattern = "*.df"), file = "my-dfs.rda")


## ----rda-06-------------------------------------------------------------------------------------------------------------
file.remove(c("my-dfs.rda", "df1.rda"))


## ----rds-1--------------------------------------------------------------------------------------------------------------
saveRDS(df1, "df1.rds")


## ----rds-1a-------------------------------------------------------------------------------------------------------------
readRDS("df1.rds")


## ----rds-2--------------------------------------------------------------------------------------------------------------
df2 <- readRDS("df1.rds")
identical(df1, df2)


## ----rds-03-------------------------------------------------------------------------------------------------------------
file.remove("df1.rds")


## ----dput-01------------------------------------------------------------------------------------------------------------
dput(df1)


## ----include=FALSE------------------------------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----plot-0, include=FALSE, cache=FALSE---------------------------------------------------------------------------------
opts_chunk$set(opts_fig_narrow_square)


## ----plot-1a, eval=FALSE------------------------------------------------------------------------------------------------
## plot(x = cars$speed, y = cars$dist)


## ----plot-1b, eval=FALSE------------------------------------------------------------------------------------------------
## with(cars, plot(x = speed, y = dist))


## ----plot-1c------------------------------------------------------------------------------------------------------------
plot(dist ~ speed, data = cars)


## ----plot-3-------------------------------------------------------------------------------------------------------------
plot(weight ~ feed, data = chickwts)


## ----gr-devices-01, message=FALSE---------------------------------------------------------------------------------------
pdf(file = "output/my-file.pdf", width = 6, height = 5, onefile = TRUE)
plot(dist ~ speed, data = cars)
plot(weight ~ feed, data = chickwts)
dev.off()


## ----gr-devices-02, message=FALSE---------------------------------------------------------------------------------------
png(file = "output/my-file.png", width = 600, height = 500)
plot(weight ~ feed, data = chickwts)
dev.off()


## ----gr-devices-03, message=FALSE---------------------------------------------------------------------------------------
png(file = "output/my-file.png", width = 600, height = 500)
plot(dist ~ speed, data = cars)
text(x = 10, y = 110, labels = "some texts to be added")
dev.off()


## ----container-chapter-cleanup, include=FALSE---------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----eval=eval_diag, include=eval_diag, echo=eval_diag, cache=FALSE-----------------------------------------------------
## knitter_diag()
## R_diag()
## other_diag()

