n  <- 50
x1 <- cbind(rnorm(n),0.2*runif(n))
x2 <- cbind(rnorm(n),1+0.2*runif(n))
x <- rbind(x1, x2)
pdf("kmeansstd.pdf", width=10, height=7)
par(mfrow=c(2,2))
xk2<- kmeans(x, 2)
plot(x, col=xk2$cluster, pch=19, main="k-means with k=2")
z <- scale(x)
zk2<- kmeans(z, 2)
plot(x, col=zk2$cluster, pch=19, main="k-means with k=2")
plot(x, pch=19, main="Unstandardized data", asp=T, ylim=c(-1.5,2))
plot(z, pch=19, main="Standardized data", asp=T, ylim=c(-1.5,2))
dev.off()
if (interactive()) browseURL(paste0(getwd(),"/kmeansstd.pdf"))