/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import com.qarks.util.PreferenceManagerImpl;
import com.qarks.util.files.diff.ui.DiffPanel;
import com.qarks.util.files.diff.ui.ResourceKeyDiff;
import com.qarks.util.ui.DialogUtilities;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class FileDiffDialog
extends JDialog
implements ActionListener {
    private JButton ok;
    private DiffPanel editor;
    private static boolean exitOnClose = false;

    private FileDiffDialog(Window window) {
        super(window, ResourceManager.getString((Object)ResourceKeyDiff.DIFF), Dialog.ModalityType.APPLICATION_MODAL);
        this.init();
    }

    private void init() {
        this.editor = new DiffPanel(PreferenceManagerImpl.getInstance().getProperty("charset.default", ""));
        Container container = this.getContentPane();
        if (container instanceof JPanel) {
            ((JPanel)container).setBorder(new EmptyBorder(10, 10, 10, 10));
        }
        container.setLayout(new BorderLayout(5, 5));
        container.add((Component)this.editor, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(2, 5, 5));
        this.ok = new JButton(ResourceManager.getString((Object)ResourceKey.OK));
        jPanel.add(this.ok);
        container.add((Component)jPanel, "South");
        this.ok.addActionListener(this);
        this.setSize(800, 600);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (exitOnClose) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    private void showAndCompute(Window window, File file, File file2) {
        this.editor.launchDiff(file, file2);
        if (window != null && window.isShowing()) {
            DialogUtilities.centerWindow(this, window);
        } else {
            DialogUtilities.centerOnScreen(this);
        }
    }

    private void showAndCompute(Window window, File file, File file2, String string, String string2) {
        this.editor.launchDiff(file, file2);
        if (window != null && window.isShowing()) {
            DialogUtilities.centerWindow(this, window);
        } else {
            DialogUtilities.centerOnScreen(this);
        }
    }

    public static void showDiffDialog(Window window, File file, File file2) {
        FileDiffDialog fileDiffDialog = new FileDiffDialog(window);
        fileDiffDialog.showAndCompute(window, file, file2);
    }

    public static void showDiffDialog(Window window, File file, File file2, String string, String string2) {
        FileDiffDialog fileDiffDialog = new FileDiffDialog(window);
        fileDiffDialog.showAndCompute(window, file, file2, string, string2);
    }

    static {
        ResourceManager.getInstance().addBundleName("resources/jdiff/properties/TextResources");
    }
}

