/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.dmg.pmml.PMML;
import org.jpmml.model.DirectByteArrayOutputStream;

public class SerializationUtil {
    private SerializationUtil() {
    }

    public static PMML deserializePMML(InputStream is) throws ClassNotFoundException, IOException {
        return SerializationUtil.deserializePMML(is, null);
    }

    public static PMML deserializePMML(InputStream is, ClassLoader clazzLoader) throws ClassNotFoundException, IOException {
        return (PMML)SerializationUtil.deserialize(is, clazzLoader);
    }

    public static Object deserialize(InputStream is) throws ClassNotFoundException, IOException {
        return SerializationUtil.deserialize(is, null);
    }

    public static Object deserialize(InputStream is, final ClassLoader clazzLoader) throws ClassNotFoundException, IOException {
        FilterInputStream safeIs = new FilterInputStream(is){

            @Override
            public void close() {
            }
        };
        try (ObjectInputStream ois = new ObjectInputStream(safeIs){

            @Override
            public Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
                Class<?> clazz;
                if (clazzLoader != null && (clazz = Class.forName(objectStreamClass.getName(), false, clazzLoader)) != null) {
                    return clazz;
                }
                return super.resolveClass(objectStreamClass);
            }
        };){
            Object object = ois.readObject();
            return object;
        }
    }

    public static void serializePMML(PMML pmml, OutputStream os) throws IOException {
        SerializationUtil.serialize(pmml, os);
    }

    public static void serialize(Object object, OutputStream os) throws IOException {
        FilterOutputStream safeOs = new FilterOutputStream(os){

            @Override
            public void close() throws IOException {
                super.flush();
            }
        };
        try (ObjectOutputStream oos = new ObjectOutputStream(safeOs);){
            oos.writeObject(object);
            oos.flush();
        }
    }

    public static <E> E clone(E object) throws ClassNotFoundException, IOException {
        return SerializationUtil.clone(object, null);
    }

    public static <E> E clone(E object, ClassLoader clazzLoader) throws ClassNotFoundException, IOException {
        DirectByteArrayOutputStream buffer = new DirectByteArrayOutputStream(0x100000);
        SerializationUtil.serialize(object, buffer);
        try (InputStream is = buffer.getInputStream();){
            Object object2 = SerializationUtil.deserialize(is, clazzLoader);
            return (E)object2;
        }
    }
}

