/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Network;

import com.conveyal.kryo.TIntArrayListSerializer;
import com.conveyal.kryo.TIntIntHashMapSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.serializers.ExternalizableSerializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import gnu.trove.impl.hash.TPrimitiveHash;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.BitSet;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.SerializingInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkChecker {
    public static final String NETWORK_FORMAT_VERSION = "nv3";
    public static final byte[] HEADER = "R5NETWORK".getBytes();
    private static final boolean COUNT_CLASS_INSTANCES = false;
    private static final Logger LOG = LoggerFactory.getLogger(NetworkChecker.class);

    public static boolean checkR5NetworkVersion(String dataFolder) throws FileNotFoundException {
        LOG.info("Reading transport network...");
        File file = new File(dataFolder, "network.dat");
        Input input = new Input((InputStream)new FileInputStream(file));
        Kryo kryo = NetworkChecker.makeKryo();
        byte[] header = new byte[HEADER.length];
        input.read(header, 0, header.length);
        if (!Arrays.equals(HEADER, header)) {
            throw new RuntimeException("Unrecognized file header. Is this an R5 Kryo network?");
        }
        String formatVersion = (String)kryo.readObject(input, String.class);
        String commit = (String)kryo.readObject(input, String.class);
        input.close();
        LOG.info("Loading network from file format version {}, written by R5 commit {}", (Object)formatVersion, (Object)commit);
        if (!NETWORK_FORMAT_VERSION.equals(formatVersion)) {
            LOG.error(String.format("File format version is %s, this R5 requires %s", formatVersion, NETWORK_FORMAT_VERSION));
            return false;
        }
        return true;
    }

    private static Kryo makeKryo() {
        Kryo kryo = new Kryo();
        kryo.setRegistrationRequired(false);
        kryo.setReferences(true);
        kryo.addDefaultSerializer(TPrimitiveHash.class, ExternalizableSerializer.class);
        kryo.register(TIntArrayList.class, (Serializer)new TIntArrayListSerializer());
        kryo.register(TIntIntHashMap.class, (Serializer)new TIntIntHashMapSerializer());
        kryo.register(BitSet.class, (Serializer)new JavaSerializer());
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new DefaultInstantiatorStrategy((InstantiatorStrategy)new SerializingInstantiatorStrategy()));
        return kryo;
    }
}

