/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.pharmacophore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.vecmath.Point3d;
import org.openscience.cdk.AtomRef;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.pharmacophore.PharmacophoreAngleBond;
import org.openscience.cdk.pharmacophore.PharmacophoreAtom;
import org.openscience.cdk.pharmacophore.PharmacophoreBond;
import org.openscience.cdk.pharmacophore.PharmacophoreQuery;
import org.openscience.cdk.pharmacophore.PharmacophoreQueryAngleBond;
import org.openscience.cdk.pharmacophore.PharmacophoreQueryAtom;
import org.openscience.cdk.pharmacophore.PharmacophoreQueryBond;
import org.openscience.cdk.smarts.SmartsPattern;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class PharmacophoreMatcher {
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(PharmacophoreMatcher.class);
    private PharmacophoreQuery pharmacophoreQuery = null;
    private IAtomContainer pharmacophoreMolecule = null;
    private Mappings mappings = null;

    public PharmacophoreMatcher() {
    }

    public PharmacophoreMatcher(PharmacophoreQuery pharmacophoreQuery) {
        this.pharmacophoreQuery = pharmacophoreQuery;
    }

    public boolean matches(IAtomContainer atomContainer) throws CDKException {
        return this.matches(atomContainer, true);
    }

    public boolean matches(IAtomContainer atomContainer, boolean initializeTarget) throws CDKException {
        if (!GeometryUtil.has3DCoordinates((IAtomContainer)atomContainer)) {
            throw new CDKException("Molecule must have 3D coordinates");
        }
        if (this.pharmacophoreQuery == null) {
            throw new CDKException("Must set the query pharmacophore before matching");
        }
        if (!this.checkQuery((IQueryAtomContainer)this.pharmacophoreQuery)) {
            throw new CDKException("A problem in the query. Make sure all pharmacophore groups of the same symbol have the same same SMARTS");
        }
        String title = atomContainer.getTitle();
        if (initializeTarget) {
            this.pharmacophoreMolecule = this.getPharmacophoreMolecule(atomContainer);
        } else {
            for (IAtom iAtom : this.pharmacophoreMolecule.atoms()) {
                PharmacophoreAtom patom = PharmacophoreAtom.get(iAtom);
                ArrayList<Integer> tmpList = new ArrayList<Integer>();
                for (int idx : patom.getMatchingAtoms()) {
                    tmpList.add(idx);
                }
                Point3d coords = this.getEffectiveCoordinates(atomContainer, tmpList);
                patom.setPoint3d(coords);
            }
        }
        if (this.pharmacophoreMolecule.getAtomCount() < this.pharmacophoreQuery.getAtomCount()) {
            this.logger.debug((Object)("Target [" + title + "] did not match the query SMARTS. Skipping constraints"));
            return false;
        }
        this.mappings = Pattern.findSubstructure((IAtomContainer)this.pharmacophoreQuery).matchAll(this.pharmacophoreMolecule);
        return this.mappings.atLeast(1);
    }

    public List<List<IBond>> getMatchingPharmacophoreBonds() {
        if (this.mappings == null) {
            return null;
        }
        ArrayList<List<IBond>> bonds = new ArrayList<List<IBond>>();
        for (Map map : this.mappings.toBondMap()) {
            bonds.add(new ArrayList(map.values()));
        }
        return bonds;
    }

    public List<HashMap<IBond, IBond>> getTargetQueryBondMappings() {
        if (this.mappings == null) {
            return null;
        }
        ArrayList<HashMap<IBond, IBond>> bondMap = new ArrayList<HashMap<IBond, IBond>>();
        for (Map map : this.mappings.toBondMap()) {
            HashMap<IBond, IBond> inv = new HashMap<IBond, IBond>();
            for (Map.Entry e : map.entrySet()) {
                inv.put((IBond)e.getValue(), (IBond)e.getKey());
            }
            bondMap.add(inv);
        }
        return bondMap;
    }

    public List<List<PharmacophoreAtom>> getMatchingPharmacophoreAtoms() {
        if (this.pharmacophoreMolecule == null || this.mappings == null) {
            return null;
        }
        return this.getPCoreAtoms(this.mappings);
    }

    public List<List<PharmacophoreAtom>> getUniqueMatchingPharmacophoreAtoms() {
        if (this.pharmacophoreMolecule == null || this.mappings == null) {
            return null;
        }
        return this.getPCoreAtoms(this.mappings.uniqueAtoms());
    }

    private List<List<PharmacophoreAtom>> getPCoreAtoms(Mappings mappings) {
        ArrayList<List<PharmacophoreAtom>> atoms = new ArrayList<List<PharmacophoreAtom>>();
        for (Map map : mappings.toAtomMap()) {
            ArrayList<PharmacophoreAtom> pcoreatoms = new ArrayList<PharmacophoreAtom>();
            for (IAtom atom : map.values()) {
                pcoreatoms.add((PharmacophoreAtom)AtomRef.deref((IAtom)atom));
            }
            atoms.add(pcoreatoms);
        }
        return atoms;
    }

    public PharmacophoreQuery getPharmacophoreQuery() {
        return this.pharmacophoreQuery;
    }

    public void setPharmacophoreQuery(PharmacophoreQuery query) {
        this.pharmacophoreQuery = query;
    }

    private IAtomContainer getPharmacophoreMolecule(IAtomContainer input) throws CDKException {
        this.prepareInput(input);
        IAtomContainer pharmacophoreMolecule = (IAtomContainer)input.getBuilder().newInstance(IAtomContainer.class, new Object[]{0, 0, 0, 0});
        HashSet<String> matched = new HashSet<String>();
        LinkedHashSet<PharmacophoreAtom> uniqueAtoms = new LinkedHashSet<PharmacophoreAtom>();
        this.logger.debug((Object)("Converting [" + input.getTitle() + "] to a pcore molecule"));
        for (IAtom atom : this.pharmacophoreQuery.atoms()) {
            PharmacophoreQueryAtom qatom = (PharmacophoreQueryAtom)atom;
            String smarts = qatom.getSmarts();
            if (!matched.add(qatom.getSymbol())) continue;
            int count = 0;
            for (SmartsPattern query : qatom.getCompiledSmarts()) {
                Mappings mappings = query.matchAll(input).uniqueAtoms();
                Iterator iterator = mappings.iterator();
                while (iterator.hasNext()) {
                    int[] mapping = (int[])iterator.next();
                    uniqueAtoms.add(this.newPCoreAtom(input, qatom, smarts, mapping));
                    ++count;
                }
            }
            this.logger.debug((Object)("\tFound " + count + " unique matches for " + smarts));
        }
        pharmacophoreMolecule.setAtoms(uniqueAtoms.toArray(new IAtom[uniqueAtoms.size()]));
        if (this.hasDistanceConstraints((IQueryAtomContainer)this.pharmacophoreQuery)) {
            int npatom = pharmacophoreMolecule.getAtomCount();
            for (int i = 0; i < npatom - 1; ++i) {
                for (int j = i + 1; j < npatom; ++j) {
                    PharmacophoreAtom atom1 = PharmacophoreAtom.get(pharmacophoreMolecule.getAtom(i));
                    PharmacophoreAtom atom2 = PharmacophoreAtom.get(pharmacophoreMolecule.getAtom(j));
                    PharmacophoreBond bond = new PharmacophoreBond(atom1, atom2);
                    pharmacophoreMolecule.addBond((IBond)bond);
                }
            }
        }
        if (this.hasAngleConstraints((IQueryAtomContainer)this.pharmacophoreQuery)) {
            int nangleDefs = 0;
            for (IBond bond : this.pharmacophoreQuery.bonds()) {
                Object tatom22;
                if (!(bond instanceof PharmacophoreQueryAngleBond)) continue;
                IAtom startQAtom = bond.getAtom(0);
                IAtom middleQAtom = bond.getAtom(1);
                IAtom endQAtom = bond.getAtom(2);
                ArrayList<Object> startl = new ArrayList<Object>();
                ArrayList<Object> middlel = new ArrayList<Object>();
                ArrayList<Object> endl = new ArrayList<Object>();
                for (Object tatom22 : pharmacophoreMolecule.atoms()) {
                    if (tatom22.getSymbol().equals(startQAtom.getSymbol())) {
                        startl.add(tatom22);
                    }
                    if (tatom22.getSymbol().equals(middleQAtom.getSymbol())) {
                        middlel.add(tatom22);
                    }
                    if (!tatom22.getSymbol().equals(endQAtom.getSymbol())) continue;
                    endl.add(tatom22);
                }
                ArrayList<IAtom[]> tmpl = new ArrayList<IAtom[]>();
                tatom22 = middlel.iterator();
                while (tatom22.hasNext()) {
                    IAtom middle = (IAtom)tatom22.next();
                    for (IAtom iAtom : startl) {
                        if (middle.equals(iAtom)) continue;
                        for (IAtom iAtom2 : endl) {
                            if (iAtom.equals(iAtom2) || middle.equals(iAtom2)) continue;
                            tmpl.add(new IAtom[]{iAtom, middle, iAtom2});
                        }
                    }
                }
                ArrayList<IAtom[]> unique = new ArrayList<IAtom[]>();
                for (int i = 0; i < tmpl.size(); ++i) {
                    IAtom[] seq1 = (IAtom[])tmpl.get(i);
                    boolean bl = false;
                    for (int j = 0; j < unique.size(); ++j) {
                        IAtom[] iAtomArray;
                        if (i == j || !Objects.equals(seq1[1], (iAtomArray = (IAtom[])unique.get(j))[1]) || !Objects.equals(seq1[0], iAtomArray[2]) || !Objects.equals(seq1[2], iAtomArray[0])) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    unique.add(seq1);
                }
                for (IAtom[] seq : unique) {
                    PharmacophoreAngleBond pharmacophoreAngleBond = new PharmacophoreAngleBond(PharmacophoreAtom.get(seq[0]), PharmacophoreAtom.get(seq[1]), PharmacophoreAtom.get(seq[2]));
                    pharmacophoreMolecule.addBond((IBond)pharmacophoreAngleBond);
                    ++nangleDefs;
                }
            }
            this.logger.debug((Object)("Added " + nangleDefs + " defs to the target pcore molecule"));
        }
        return pharmacophoreMolecule;
    }

    private PharmacophoreAtom newPCoreAtom(IAtomContainer input, PharmacophoreQueryAtom qatom, String smarts, int[] mapping) {
        Point3d coords = this.getEffectiveCoordinates(input, mapping);
        PharmacophoreAtom patom = new PharmacophoreAtom(smarts, qatom.getSymbol(), coords);
        patom.setMatchingAtoms(mapping);
        return patom;
    }

    private void prepareInput(IAtomContainer input) throws CDKException {
        SmartsPattern.prepare((IAtomContainer)input);
    }

    private boolean hasDistanceConstraints(IQueryAtomContainer query) {
        for (IBond bond : query.bonds()) {
            if (!(bond instanceof PharmacophoreQueryBond)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAngleConstraints(IQueryAtomContainer query) {
        for (IBond bond : query.bonds()) {
            if (!(bond instanceof PharmacophoreQueryAngleBond)) continue;
            return true;
        }
        return false;
    }

    private int[] intIndices(List<Integer> atomIndices) {
        int[] ret = new int[atomIndices.size()];
        for (int i = 0; i < atomIndices.size(); ++i) {
            ret[i] = atomIndices.get(i);
        }
        return ret;
    }

    private Point3d getEffectiveCoordinates(IAtomContainer atomContainer, List<Integer> atomIndices) {
        Point3d ret = new Point3d(0.0, 0.0, 0.0);
        for (Integer atomIndice : atomIndices) {
            int atomIndex = atomIndice;
            Point3d coord = atomContainer.getAtom(atomIndex).getPoint3d();
            ret.x += coord.x;
            ret.y += coord.y;
            ret.z += coord.z;
        }
        ret.x /= (double)atomIndices.size();
        ret.y /= (double)atomIndices.size();
        ret.z /= (double)atomIndices.size();
        return ret;
    }

    private Point3d getEffectiveCoordinates(IAtomContainer atomContainer, int[] atomIndices) {
        Point3d ret = new Point3d(0.0, 0.0, 0.0);
        for (int i : atomIndices) {
            Point3d coord = atomContainer.getAtom(i).getPoint3d();
            ret.x += coord.x;
            ret.y += coord.y;
            ret.z += coord.z;
        }
        ret.x /= (double)atomIndices.length;
        ret.y /= (double)atomIndices.length;
        ret.z /= (double)atomIndices.length;
        return ret;
    }

    private boolean checkQuery(IQueryAtomContainer query) {
        if (!(query instanceof PharmacophoreQuery)) {
            return false;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < query.getAtomCount(); ++i) {
            IQueryAtom atom = (IQueryAtom)query.getAtom(i);
            if (!(atom instanceof PharmacophoreQueryAtom)) {
                return false;
            }
            PharmacophoreQueryAtom pqatom = (PharmacophoreQueryAtom)atom;
            String label = pqatom.getSymbol();
            String smarts = pqatom.getSmarts();
            if (!map.containsKey(label)) {
                map.put(label, smarts);
                continue;
            }
            if (((String)map.get(label)).equals(smarts)) continue;
            return false;
        }
        return true;
    }
}

