/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.atomtype;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.atomtype.IAtomTypeMatcher;
import org.openscience.cdk.atomtype.mapper.AtomTypeMapper;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;

public class SybylAtomTypeMatcher
implements IAtomTypeMatcher {
    private static final String SYBYL_ATOM_TYPE_LIST = "org/openscience/cdk/dict/data/sybyl-atom-types.owl";
    private static final String CDK_TO_SYBYL_MAP = "org/openscience/cdk/dict/data/cdk-sybyl-mappings.owl";
    private final AtomTypeFactory factory;
    private final CDKAtomTypeMatcher cdkMatcher;
    private final AtomTypeMapper mapper;
    private static final Map<IChemObjectBuilder, SybylAtomTypeMatcher> factories = new Hashtable<IChemObjectBuilder, SybylAtomTypeMatcher>(1);

    private SybylAtomTypeMatcher(IChemObjectBuilder builder) {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(SYBYL_ATOM_TYPE_LIST);
        this.factory = AtomTypeFactory.getInstance((InputStream)stream, (String)"owl", (IChemObjectBuilder)builder);
        this.cdkMatcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)builder);
        InputStream mapStream = this.getClass().getClassLoader().getResourceAsStream(CDK_TO_SYBYL_MAP);
        this.mapper = AtomTypeMapper.getInstance(CDK_TO_SYBYL_MAP, mapStream);
    }

    public static SybylAtomTypeMatcher getInstance(IChemObjectBuilder builder) {
        if (!factories.containsKey(builder)) {
            factories.put(builder, new SybylAtomTypeMatcher(builder));
        }
        return factories.get(builder);
    }

    public IAtomType[] findMatchingAtomTypes(IAtomContainer atomContainer) throws CDKException {
        Iterator iterator = atomContainer.atoms().iterator();
        while (iterator.hasNext()) {
            IAtom atom;
            IAtomType type = this.cdkMatcher.findMatchingAtomType(atomContainer, atom = (IAtom)iterator.next());
            atom.setAtomTypeName(type == null ? null : type.getAtomTypeName());
            atom.setHybridization(type == null ? null : type.getHybridization());
        }
        Aromaticity.cdkLegacy().apply(atomContainer);
        IAtomType[] types = new IAtomType[atomContainer.getAtomCount()];
        int typeCounter = 0;
        for (IAtom atom : atomContainer.atoms()) {
            String mappedType = this.mapCDKToSybylType(atom);
            types[typeCounter] = mappedType == null ? null : this.factory.getAtomType(mappedType);
            ++typeCounter;
        }
        return types;
    }

    public IAtomType findMatchingAtomType(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type = this.cdkMatcher.findMatchingAtomType(atomContainer, atom);
        if (atom.getAtomicNumber() != null) {
            int neibors;
            if (atom.getAtomicNumber() == 24) {
                int neighbors = atomContainer.getConnectedBondsCount(atom);
                if (neighbors > 4 && neighbors <= 6) {
                    return this.factory.getAtomType("Cr.oh");
                }
                if (neighbors > 0) {
                    return this.factory.getAtomType("Cr.th");
                }
            } else if (atom.getAtomicNumber() == 27 && (neibors = atomContainer.getConnectedBondsCount(atom)) == 6) {
                return this.factory.getAtomType("Co.oh");
            }
        }
        if (type == null) {
            return null;
        }
        atom.setAtomTypeName(type.getAtomTypeName());
        String mappedType = this.mapCDKToSybylType(atom);
        if (mappedType == null) {
            return null;
        }
        if (("O.3".equals(mappedType) || "O.2".equals(mappedType)) && this.isCarbonyl(atomContainer, atom)) {
            mappedType = "O.co2";
        }
        if ("N.2".equals(mappedType) && this.isNitro(atomContainer, atom)) {
            mappedType = "N.pl3";
        }
        return this.factory.getAtomType(mappedType);
    }

    private boolean isCarbonyl(IAtomContainer atomContainer, IAtom atom) {
        List neighbors = atomContainer.getConnectedBondsList(atom);
        if (neighbors.size() != 1) {
            return false;
        }
        IBond neighbor = (IBond)neighbors.get(0);
        IAtom neighborAtom = neighbor.getOther(atom);
        return neighborAtom.getAtomicNumber() == 6 && (neighbor.getOrder() == IBond.Order.SINGLE ? this.countAttachedBonds(atomContainer, neighborAtom, IBond.Order.DOUBLE, "O") == 1 : neighbor.getOrder() == IBond.Order.DOUBLE && this.countAttachedBonds(atomContainer, neighborAtom, IBond.Order.SINGLE, "O") == 1);
    }

    private boolean isNitro(IAtomContainer atomContainer, IAtom atom) {
        List neighbors = atomContainer.getConnectedAtomsList(atom);
        if (neighbors.size() != 3) {
            return false;
        }
        int oxygenCount = 0;
        for (IAtom neighbor : neighbors) {
            if (neighbor.getAtomicNumber() != 8) continue;
            ++oxygenCount;
        }
        return oxygenCount == 2;
    }

    private int countAttachedBonds(IAtomContainer container, IAtom atom, IBond.Order order, String symbol) {
        List neighbors = container.getConnectedBondsList(atom);
        int neighborcount = neighbors.size();
        int doubleBondedAtoms = 0;
        for (int i = neighborcount - 1; i >= 0; --i) {
            IBond bond = (IBond)neighbors.get(i);
            if (bond.getOrder() != order || bond.getAtomCount() != 2 || !bond.contains(atom)) continue;
            if (symbol != null) {
                IAtom neighbor = bond.getOther(atom);
                if (!symbol.equals(neighbor.getSymbol())) continue;
                ++doubleBondedAtoms;
                continue;
            }
            ++doubleBondedAtoms;
        }
        return doubleBondedAtoms;
    }

    private String mapCDKToSybylType(IAtom atom) {
        String typeName = atom.getAtomTypeName();
        if (typeName == null) {
            return null;
        }
        String mappedType = this.mapper.mapAtomType(typeName);
        if ("C.2".equals(mappedType) && atom.getFlag(32)) {
            mappedType = "C.ar";
        } else if ("N.2".equals(mappedType) && atom.getFlag(32)) {
            mappedType = "N.ar";
        } else if ("N.pl3".equals(mappedType) && atom.getFlag(32)) {
            mappedType = "N.ar";
        }
        return mappedType;
    }
}

