/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.Arrays;

final class UnionFind {
    final int[] forest;

    UnionFind(int n) {
        this.forest = new int[n];
        Arrays.fill(this.forest, -1);
    }

    int find(int u) {
        return this.forest[u] < 0 ? u : this.find(this.forest[u]);
    }

    void union(int u, int v) {
        int vRoot;
        int uRoot = this.find(u);
        if (uRoot == (vRoot = this.find(v))) {
            return;
        }
        if (this.forest[uRoot] < this.forest[vRoot]) {
            this.join(vRoot, uRoot);
        } else {
            this.join(uRoot, vRoot);
        }
    }

    private void join(int sRoot, int lRoot) {
        this.forest[sRoot] = this.forest[sRoot] + this.forest[lRoot];
        this.forest[lRoot] = sRoot;
    }

    boolean connected(int u, int v) {
        return this.find(u) == this.find(v);
    }

    void clear() {
        for (int i = 0; i < this.forest.length; ++i) {
            this.forest[i] = -1;
        }
    }
}

