/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.util.Collections;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.DfState;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;

public class DfPattern
extends Pattern {
    private final IAtomContainer src;
    private final IAtomContainer query;
    private final DfState state;

    private DfPattern(IAtomContainer src, IAtomContainer query) {
        this.src = src;
        this.query = query;
        this.determineFilters(query);
        this.state = new DfState(query);
    }

    private static void checkCompatibleAPI(IAtom atom) {
        if (atom.getContainer() == null) {
            throw new IllegalArgumentException("This API can only be used with the option CdkUseLegacyAtomContainer=false (default). The atoms in the molecule provided do not know about their parent molecule");
        }
    }

    @Override
    public int[] match(IAtomContainer target) {
        return this.matchAll(target).first();
    }

    @Override
    public boolean matches(IAtomContainer target) {
        return this.matchAll(target).atLeast(1);
    }

    @Override
    public Mappings matchAll(IAtomContainer mol) {
        if (mol.getAtomCount() < this.query.getAtomCount()) {
            return new Mappings(this.src, mol, Collections.emptySet());
        }
        if (mol.getAtomCount() > 0) {
            DfPattern.checkCompatibleAPI(mol.getAtom(0));
        }
        DfState local = new DfState(this.state);
        local.setMol(mol);
        return this.filter(new Mappings(this.src, mol, local), this.query, mol);
    }

    Mappings matchRoot(IAtom root) {
        DfPattern.checkCompatibleAPI(root);
        IAtomContainer mol = root.getContainer();
        if (this.query.getAtomCount() > 0 && ((IQueryAtom)this.query.getAtom(0)).matches(root)) {
            DfState local = new DfState(this.state);
            local.setRoot(root);
            return this.filter(new Mappings(this.query, mol, local), this.query, mol);
        }
        return new Mappings(this.query, mol, Collections.emptySet());
    }

    public boolean matchesRoot(IAtom root) {
        return this.matchRoot(root).atLeast(1);
    }

    public static DfPattern findSubstructure(IAtomContainer query) {
        if (!DfPattern.isCompleteQuery(query)) {
            return new DfPattern(query, (IAtomContainer)QueryAtomContainer.create(query, Expr.Type.ALIPHATIC_ELEMENT, Expr.Type.AROMATIC_ELEMENT, Expr.Type.SINGLE_OR_AROMATIC, Expr.Type.ALIPHATIC_ORDER, Expr.Type.STEREOCHEMISTRY));
        }
        return new DfPattern(query, query);
    }

    private static boolean isCompleteQuery(IAtomContainer query) {
        for (IAtom atom : query.atoms()) {
            if (atom instanceof IQueryAtom) continue;
            return false;
        }
        for (IBond bond : query.bonds()) {
            if (bond instanceof IQueryBond) continue;
            return false;
        }
        return true;
    }
}

