/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.traverse.ClosestFirstIterator;

public final class DijkstraShortestPath {
    private List m_edgeList;
    private double m_pathLength;

    public DijkstraShortestPath(Graph graph, Object object, Object object2, double d) {
        ClosestFirstIterator closestFirstIterator = new ClosestFirstIterator(graph, object, d);
        while (closestFirstIterator.hasNext()) {
            Object object3 = closestFirstIterator.next();
            if (!object3.equals(object2)) continue;
            this.createEdgeList(closestFirstIterator, object2);
            this.m_pathLength = closestFirstIterator.getShortestPathLength(object2);
            return;
        }
        this.m_edgeList = null;
        this.m_pathLength = Double.POSITIVE_INFINITY;
    }

    public List getPathEdgeList() {
        return this.m_edgeList;
    }

    public double getPathLength() {
        return this.m_pathLength;
    }

    public static List findPathBetween(Graph graph, Object object, Object object2) {
        DijkstraShortestPath dijkstraShortestPath = new DijkstraShortestPath(graph, object, object2, Double.POSITIVE_INFINITY);
        return dijkstraShortestPath.getPathEdgeList();
    }

    private void createEdgeList(ClosestFirstIterator closestFirstIterator, Object object) {
        Edge edge;
        this.m_edgeList = new ArrayList();
        while ((edge = closestFirstIterator.getSpanningTreeEdge(object)) != null) {
            this.m_edgeList.add(edge);
            object = edge.oppositeVertex(object);
        }
        Collections.reverse(this.m_edgeList);
    }
}

