/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.io.IOException;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class VdWRadiusDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private static final String[] NAMES = new String[]{"vdwRadius"};

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#vdwradius", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
    }

    public Object[] getParameters() {
        return null;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    public DescriptorValue calculate(IAtom atom, IAtomContainer container) {
        String symbol = atom.getSymbol();
        double vdwradius = PeriodicTable.getVdwRadius((String)symbol);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(vdwradius), NAMES);
    }

    public String[] getParameterNames() {
        return new String[0];
    }

    public Object getParameterType(String name) {
        return null;
    }
}

