/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.move;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.limits.ICounter;
import org.chocosolver.solver.search.limits.SolutionCounter;
import org.chocosolver.solver.search.loop.lns.neighbors.INeighbor;
import org.chocosolver.solver.search.loop.move.MoveBinaryDDS;
import org.chocosolver.solver.search.loop.move.MoveBinaryDFS;
import org.chocosolver.solver.search.loop.move.MoveBinaryHBFS;
import org.chocosolver.solver.search.loop.move.MoveBinaryLDS;
import org.chocosolver.solver.search.loop.move.MoveLNS;
import org.chocosolver.solver.search.restart.GeometricalCutoff;
import org.chocosolver.solver.search.restart.ICutoff;
import org.chocosolver.solver.search.restart.LinearCutoff;
import org.chocosolver.solver.search.restart.LubyCutoff;
import org.chocosolver.solver.search.restart.MonotonicCutoff;
import org.chocosolver.solver.search.restart.Restarter;
import org.chocosolver.util.criteria.LongCriterion;

public interface IMoveFactory
extends ISelf<Solver> {
    default public void setDFS() {
        ((Solver)this.ref()).setMove(new MoveBinaryDFS(((Solver)this.ref()).getSearch()));
    }

    default public void setLDS(int discrepancy) {
        IEnvironment env = ((Solver)this.ref()).getEnvironment();
        ((Solver)this.ref()).setMove(new MoveBinaryLDS(((Solver)this.ref()).getSearch(), discrepancy, env));
    }

    default public void setDDS(int discrepancy) {
        IEnvironment env = ((Solver)this.ref()).getEnvironment();
        ((Solver)this.ref()).setMove(new MoveBinaryDDS(((Solver)this.ref()).getSearch(), discrepancy, env));
    }

    default public void setHBFS(double a, double b, long N) {
        ((Solver)this.ref()).setMove(new MoveBinaryHBFS(((Solver)this.ref()).getModel(), ((Solver)this.ref()).getSearch(), a, b, N));
    }

    default public void setRestarts(LongCriterion restartCriterion, ICutoff restartStrategy, int restartsLimit) {
        ((Solver)this.ref()).setRestarts(restartCriterion, restartStrategy, restartsLimit, true);
    }

    default public void setRestarts(LongCriterion restartCriterion, ICutoff restartStrategy, int restartsLimit, boolean resetCutoffOnSolution) {
        ((Solver)this.ref()).addRestarter(new Restarter(restartStrategy, restartCriterion, restartsLimit, resetCutoffOnSolution));
    }

    default public void setLubyRestart(long scaleFactor, ICounter restartStrategyLimit, int restartLimit) {
        ((Solver)this.ref()).setRestarts(restartStrategyLimit, new LubyCutoff(scaleFactor), restartLimit);
    }

    default public void setGeometricalRestart(long base, double geometricalFactor, ICounter restartStrategyLimit, int restartLimit) {
        ((Solver)this.ref()).setRestarts(restartStrategyLimit, new GeometricalCutoff(base, geometricalFactor), restartLimit);
    }

    default public void setLinearRestart(long scaleFactor, ICounter restartStrategyLimit, int restartLimit) {
        ((Solver)this.ref()).setRestarts(restartStrategyLimit, new LinearCutoff(scaleFactor), restartLimit);
    }

    default public void setConstantRestart(long scaleFactor, ICounter restartStrategyLimit, int restartLimit) {
        ((Solver)this.ref()).setRestarts(restartStrategyLimit, new MonotonicCutoff(scaleFactor), restartLimit);
    }

    default public void setRestartOnSolutions() {
        ((Solver)this.ref()).addRestarter(new Restarter(new MonotonicCutoff(1L), new SolutionCounter(((Solver)this.ref()).getModel(), 1L), Integer.MAX_VALUE, true));
    }

    default public void setLNS(INeighbor neighbor, ICounter restartCounter, Solution bootstrap) {
        MoveLNS lns = new MoveLNS(((Solver)this.ref()).getMove(), neighbor, restartCounter);
        ((Solver)this.ref()).setMove(lns);
        if (bootstrap != null) {
            lns.loadFromSolution(bootstrap, (Solver)this.ref());
        }
    }

    default public void setLNS(INeighbor neighbor, Solution bootstrap) {
        this.setLNS(neighbor, ICounter.Impl.None, bootstrap);
    }

    default public void setLNS(INeighbor neighbor, ICounter restartCounter) {
        this.setLNS(neighbor, restartCounter, null);
    }

    default public void setLNS(INeighbor neighbor) {
        this.setLNS(neighbor, ICounter.Impl.None, null);
    }
}

