/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.discretization;

import java.util.ArrayList;
import java.util.List;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.discretization.AbstractDiscretizationMethod;
import org.vikamine.kernel.data.discretization.DiscretizationUtils;

public class EqualWidthDiscretizer
extends AbstractDiscretizationMethod {
    private static final String NAME = "Equal Width Discretizer";

    public EqualWidthDiscretizer() {
    }

    public EqualWidthDiscretizer(int segmentsCount) {
        this.segmentsCount = segmentsCount;
    }

    public EqualWidthDiscretizer(DataView population, NumericAttribute na, int segmentsCount) {
        this.population = population;
        this.attribute = na;
        this.segmentsCount = segmentsCount;
    }

    @Override
    public List<Double> getCutpoints() {
        if (this.population == null || this.attribute == null || this.population.dataset().getIndex(this.attribute) < 0 || this.segmentsCount < 2 || this.population.size() < 2) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> cutpoints = new ArrayList<Double>(this.segmentsCount + 1);
        double[] attributesMinAndMaxValue = DiscretizationUtils.getMinMaxValue(this.population, this.attribute);
        double segmentWidth = (attributesMinAndMaxValue[1] - attributesMinAndMaxValue[0]) / (double)this.segmentsCount;
        int i = 1;
        while (i <= this.segmentsCount - 1) {
            cutpoints.add(attributesMinAndMaxValue[0] + segmentWidth * (double)i);
            ++i;
        }
        return cutpoints;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<Double> getSortedSample() {
        return null;
    }
}

