/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.analysis.causality;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.analysis.causality.CausalSGNode;

public class CausalSGNet {
    private HashMap nodes = new HashMap();

    public Collection getNodes() {
        return this.nodes.values();
    }

    public Collection getContainedSubgroups() {
        return this.nodes.keySet();
    }

    public void addNode(CausalSGNode node) {
        this.nodes.put(node.getSG(), node);
    }

    public String toString() {
        return this.nodes.values().toString();
    }

    public CausalSGNode getNode(SG sg) {
        return (CausalSGNode)this.nodes.get(sg);
    }

    public void recalculateLevels() {
        for (CausalSGNode node : this.nodes.values()) {
            if (!node.getParents().isEmpty() || node.getChildren().isEmpty() && node.getApproxEqualSubgroups().isEmpty()) continue;
            node.setLevel(0);
        }
        LinkedList sortedNodes = new LinkedList(this.nodes.values());
        Collections.sort(sortedNodes, new Comparator(){

            public int compare(Object o1, Object o2) {
                CausalSGNode n1 = (CausalSGNode)o1;
                CausalSGNode n2 = (CausalSGNode)o2;
                if (n1.getLevel() == n2.getLevel()) {
                    return 0;
                }
                return n1.getLevel() < n2.getLevel() ? -1 : 1;
            }
        });
        for (CausalSGNode node : sortedNodes) {
            int currentLevel = node.getLevel();
            if (node.getChildren() == null) continue;
            LinkedList children = new LinkedList(node.getChildren());
            if (node.getApproxEqualSubgroups() != null) {
                children.addAll(node.getApproxEqualSubgroups());
            }
            Iterator childrenIterator = children.iterator();
            while (childrenIterator.hasNext()) {
                CausalSGNode child = null;
                Object next = childrenIterator.next();
                child = next instanceof SG ? this.getNode((SG)next) : (CausalSGNode)next;
                child.setLevel(currentLevel + 1);
            }
        }
    }

    public void recalculateLevelsAllowingCircles() {
        for (CausalSGNode node : this.nodes.values()) {
            node.setLevel(-1);
        }
        for (CausalSGNode node : this.nodes.values()) {
            HashSet children = new HashSet(node.getChildren());
            children.addAll(node.getCCAssociations());
            if (children.isEmpty()) continue;
            if (node.getLevel() == -1) {
                node.setLevel(0);
            }
            children = new HashSet(node.getChildren());
            if (node.getApproxEqualSubgroups() != null) {
                children.addAll(node.getApproxEqualSubgroups());
            }
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                CausalSGNode child = null;
                Object next = childIter.next();
                child = next instanceof SG ? this.getNode((SG)next) : (CausalSGNode)next;
                if (child.getLevel() != -1) continue;
                child.setLevel(node.getLevel() + 1);
            }
        }
    }
}

