## ----echo = F, eval = F-------------------------------------------------------
# A <- matrix(nrow = 3, ncol = 3, data = c(4,3,2,1,-3,3,7,-8,2), byrow = T)
# B <- matrix(nrow = 3, ncol = 3, data = c(0,1,2,2,4,6,-1,2,-2), byrow = T)
# A-B
# x <- 2
# x - B
# t(A)

## ----comment = NA-------------------------------------------------------------
A <- matrix(nrow = 3, ncol = 3, data = c(4,3,2,1,-3,3,7,-8,2),
            byrow = T)
A
t(A)

## ----comment = NA-------------------------------------------------------------
A <- matrix(2, 3, data = c(1, 2, 3, 4, 5, 6))
A
B <- matrix(3, 2, data = c(2, 1, -2, 0, 1, 9))
B
AB <- A%*%B
AB

## ----comment = NA-------------------------------------------------------------
A <- matrix(nrow = 3, ncol = 3, data = c(4,3,2,1,-3,3,7,-8,2),
            byrow = T)
A
trace <- sum(diag(A))
trace

## ----comment = NA-------------------------------------------------------------
A <- matrix(2,2, data = c(2,0,0,2), byrow = T)
A
det(A)

## ----comment = NA, eval = F---------------------------------------------------
# library(RConics)
# A <- matrix(3,3, data = c(5,7,6,1,5,4,1,3,2), byrow = T)
# A
# adjoint(A)

## ----comment = NA-------------------------------------------------------------
A <- matrix(2,2,data = c(3,-1,2,0))
solve(A)

## ----echo = F, eval = F-------------------------------------------------------
# quadratic.eq <- function(a, b, c){
# sol1 <- (-b + sqrt(b^2-(4 * a * c)))/2 * a
# sol2 <- (-b - sqrt(b^2-(4 * a * c)))/2 * a
# res<-list()
# res$solution1 <- sol1
# res$solution2 <- sol2
# res
# }
# 
# quadratic.eq(1, -2, -3)

## ----comment = NA-------------------------------------------------------------
A <- matrix(2,2,data = c(1,-2,-2,1))
eigen(A)

## ----comment = NA-------------------------------------------------------------
LH.eigen <- function(A){
  eigen(t(A))
}

LH.eigen(A)

## ----comment = NA, message = F, warning = F-----------------------------------
library(igraph)

G <- graph_from_literal(a --+ b --+ c)
A <- as_adjacency_matrix(G, sparse = F)
A

## ----comment = NA-------------------------------------------------------------
A %*% A

## ----comment = NA-------------------------------------------------------------
G1 <- G
E(G1)$weight <- c(0.1, 0.2)

## ----comment = NA-------------------------------------------------------------
E(G1)

## -----------------------------------------------------------------------------
weights <- c(0.1, 0.2)
G2 <- set_edge_attr(G, "weight", value = as.numeric(weights))
attr <- "weight"

## ----comment = NA-------------------------------------------------------------
as_adjacency_matrix(G2, attr = "weight", sparse = F)

## -----------------------------------------------------------------------------
alpha <- 1

## ----comment = NA-------------------------------------------------------------
G <- graph_from_literal(4 --+ 3 --+ 2 --+ 1)
A <- as_adjacency_matrix(G, sparse = F)
A

## ----comment = NA-------------------------------------------------------------
alpha * t(A)

## ----comment = NA-------------------------------------------------------------
I <- matrix(0,4,4); diag(I) <- 1
I - (alpha * t(A))

## ----comment = NA-------------------------------------------------------------
B <- I - (alpha * t(A))
solve(B)

## ----comment = NA-------------------------------------------------------------
one <- matrix(4,1, data = rep(1,4))
solve(B) %*% one

## ----comment = NA-------------------------------------------------------------
A <- as_adjacency_matrix(G, sparse = F)
alpha <- 0.5
alpha * t(A)

## ----comment = NA-------------------------------------------------------------
I <- matrix(0,4,4); diag(I) <- 1
B <- I - alpha * t(A)
B

## ----comment = NA-------------------------------------------------------------
solve(B)

## ----comment = NA-------------------------------------------------------------
solve(B) %*% rep(1,4)

## -----------------------------------------------------------------------------
graph_A <- graph_from_literal(7 --+ 6 --+ 5 --+ 3,
                              4 --+ 3, 3--+ 2, 2--+ 1)
graph_B <- graph_from_literal(7 --+ 6 --+ 5, 6 --+ 4,
                              5 --+ 3, 4 --+ 3, 3--+ 2, 2--+ 1)

## ----comment = NA-------------------------------------------------------------
A_A <- as_adjacency_matrix(graph_A, sparse = F)
A_A
A_B <- as_adjacency_matrix(graph_B, sparse = F)
A_B

## ----comment = NA-------------------------------------------------------------
alpha <- 1
I <- matrix(0,7,7); diag(I) <- 1
I - (alpha * t(A_A))

I - (alpha * t(A_B))

## ----comment = NA-------------------------------------------------------------
B_A <- I - alpha * t(A_A)
solve(B_A)

B_B <- I - alpha * t(A_B)
solve(B_B)

## ----comment = NA-------------------------------------------------------------
solve(B_A) %*% rep(1, 7)

solve(B_B) %*% rep(1, 7)

## ----comment = NA-------------------------------------------------------------
alpha <- 0.5
I <- matrix(0,7,7); diag(I) <- 1
B_A <- I - (alpha * t(A_A))
B_B <- I - (alpha * t(A_B))

solve(B_A)
solve(B_B)

## ----message = F, warning = F, comment = NA, echo = F-------------------------
library(streamDAG)
m0 <- graph_from_literal(2--+ 1)
m1 <- graph_from_literal(3 --+ 2, 2--+ 1)
m2 <- graph_from_literal(4 --+ 3, 5 --+ 3, 3--+ 2, 2--+ 1)
m3 <- graph_from_literal(8 --+ 2, 7 --+ 6, 6 --+ 3, 4 --+ 3, 5 --+ 3, 3--+ 2, 2--+ 1)
m4 <- graph_from_literal(8 --+ 6, 7 --+ 6, 6 --+ 3, 4 --+ 3, 5 --+ 3, 3--+ 2, 9-+2, 2--+ 1)
m5 <- graph_from_literal(8 --+ 6, 7 --+ 6, 6 --+ 3, 4 --+ 3, 5 --+ 3, 3--+ 2, 9-+2, 10 --+ 1, 2--+ 1)

m6 <- graph_from_literal(7 --+ 5, 7 --+ 6 --+ 3, 5 --+ 3, 4--+ 3, 3--+ 2, 2--+ 1)
m7 <- graph_from_literal(8 --+ 7 --+ 5, 7 --+ 6 --+ 3, 5 --+ 3, 4--+ 3, 3--+ 2, 2--+ 1)
#m5 <- graph_from_literal(7 --+ 6, 6 --+ 3, 4 --+ 3, 5 --+ 3, 3--+ 2, 2--+ 1)
m8 <- graph_from_literal(9 --+ 8 --+ 7 --+ 5, 7 --+ 6 --+ 3, 5 --+ 3, 4--+ 3, 3--+ 2, 2--+ 1)

dags <- list(m0, m1, m2, m3, m4, m5, m6, m7, m8)
tailf <- function(x) tail(x, n = 1)

dagcent1 <- sapply(dags, function(x) alpha.centrality(x, alpha = 1))
alpha.cent1 <- sapply(dagcent1, function(x)tail(x,1))
dagcent.5 <- sapply(dags, function(x) alpha.centrality(x, alpha = 0.5))
alpha.cent.5 <- sapply(dagcent.5, function(x)tail(x,1))
dagcent.75 <- sapply(dags, function(x) alpha.centrality(x, alpha = 0.75))
alpha.cent.75 <- sapply(dagcent.75, function(x)tail(x,1))
dagpath <- sapply(dags, function(x)local.summary(x, "n.paths"))
npaths <- sapply(dagpath, function(x)tail(x,1))
dagorder <- sapply(dags, function(x)local.summary(x, "size.intact.in"))
dorder <- sapply(dagorder, function(x)tail(x,1))

## ----echo = F, message = F, warning = F, results = 'asis', eval = F-----------
# library(xtable)
# graph <- LETTERS[1:9]
# tab <- xtable(data.frame(Graph = graph, A.cent.5 = alpha.cent.5, A.cent.75 = alpha.cent.75, A.cent1 = alpha.cent1, npath = npaths, order = dorder), caption = "Summary of outlet nodes (node 1) for DAGs in Fig \\ref{fig:f1}. Alpha centralities calculated using $\\alpha = 1$, $\\alpha = 0.75$, and $\\alpha = 0.5$. ", label = "tab:gams")
# # names(tab) <- c("Graph", "Alpha-cent. $\\alpha = 0.5$", "Alpha-cent. $\\alpha = 0.75$", "Alpha-cent. $\\alpha = 1$", "Paths", "Graph Order")
# 
# print(tab, include.rownames = FALSE, caption.placement = "top",table.placement = "h!")

## ----message = F, warning = F, comment = NA-----------------------------------
G <- graph_from_literal(a --+ c, c --+ e, e --+ f, f --+ p,
                        p --+ q, q --+ r,
                        b --+ d, d --+ e,
                        g --+ i, i --+ j, i --+ k, k --+ m,
                        j --+ m, m --+ n,  n--+ o, o --+ p,
                        h --+ l, l --+ n)

weight.matrix <- data.frame(matrix(ncol = 2, nrow = 18, data = c(
  "a->c", 0.2, "c->e", 0.2, "e->f", 0.2,  "f->p", 0.5,  "p->q", 0.7,
  "q->r", 0.9, "b->d", 0.1, "d->e", 0.3,  "g->i", 0.2,  "i->j", 0.1,
  "i->k", 0.6, "j->m", 0.5, "k->m", 0.5,  "m->n", 0.4,  "n->o", 0.3,
  "o->p", 0.2,  "h->l", 0.1, "l->n", 0.3), byrow = T))

names(weight.matrix) <- c("Arc", "Weight")
weight.matrix$"Weight" <- as.numeric(weight.matrix$"Weight")

## ----comment = NA-------------------------------------------------------------
alpha <- 1

## ----comment = NA-------------------------------------------------------------
A <- as_adjacency_matrix(G, sparse = F)
A

## ----comment = NA-------------------------------------------------------------
W <- G
weights <- weight.matrix[,2]

W <- set_edge_attr(W, "weight", value = as.numeric(weights))
attr <- "weight"

## ----comment = NA-------------------------------------------------------------
D <- as_adjacency_matrix(W, attr = attr, sparse = FALSE)
D

## ----comment = NA-------------------------------------------------------------
I <- matrix(0, nrow = nrow(D), ncol = ncol(D)); diag(I) <- 1
B <- I - alpha * t(D)

## ----comment = NA-------------------------------------------------------------
solve(B)

## ----comment = NA-------------------------------------------------------------
solve(B) %*% rep(1,nrow(D))

