/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.lazy.neighboursearch.kdtrees;

import moa.classifiers.lazy.neighboursearch.kdtrees.KDTreeNode;
import moa.classifiers.lazy.neighboursearch.kdtrees.KDTreeNodeSplitter;

public class MedianOfWidestDimension
extends KDTreeNodeSplitter {
    private static final long serialVersionUID = 1383443320160540663L;

    public String globalInfo() {
        return "The class that splits a KDTree node based on the median value of a dimension in which the node's points have the widest spread.\n\nFor more information see also:\n\n";
    }

    @Override
    public void splitNode(KDTreeNode node, int numNodesCreated, double[][] nodeRanges, double[][] universe) throws Exception {
        this.correctlyInitialized();
        int splitDim = this.widestDim(nodeRanges, universe);
        int medianIdxIdx = node.m_Start + (node.m_End - node.m_Start) / 2;
        int medianIdx = this.select(splitDim, this.m_InstList, node.m_Start, node.m_End, (node.m_End - node.m_Start) / 2 + 1);
        node.m_SplitDim = splitDim;
        node.m_SplitValue = this.m_Instances.instance(this.m_InstList[medianIdx]).value(splitDim);
        node.m_Left = new KDTreeNode(numNodesCreated + 1, node.m_Start, medianIdxIdx, this.m_EuclideanDistance.initializeRanges(this.m_InstList, node.m_Start, medianIdxIdx));
        node.m_Right = new KDTreeNode(numNodesCreated + 2, medianIdxIdx + 1, node.m_End, this.m_EuclideanDistance.initializeRanges(this.m_InstList, medianIdxIdx + 1, node.m_End));
    }

    protected int partition(int attIdx, int[] index, int l, int r) {
        double pivot = this.m_Instances.instance(index[(l + r) / 2]).value(attIdx);
        while (l < r) {
            while (this.m_Instances.instance(index[l]).value(attIdx) < pivot && l < r) {
                ++l;
            }
            while (this.m_Instances.instance(index[r]).value(attIdx) > pivot && l < r) {
                --r;
            }
            if (l >= r) continue;
            int help = index[l];
            index[l] = index[r];
            index[r] = help;
            ++l;
            --r;
        }
        if (l == r && this.m_Instances.instance(index[r]).value(attIdx) > pivot) {
            --r;
        }
        return r;
    }

    public int select(int attIdx, int[] indices, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int middle = this.partition(attIdx, indices, left, right);
        if (middle - left + 1 >= k) {
            return this.select(attIdx, indices, left, middle, k);
        }
        return this.select(attIdx, indices, middle + 1, right, k - (middle - left + 1));
    }
}

