/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.util.Arrays;
import java.util.LinkedList;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.MultiClassClassifier;
import moa.core.Measurement;
import moa.core.MiscUtils;
import moa.options.ClassOption;

public class PairedLearners
extends AbstractClassifier
implements MultiClassClassifier {
    private static final long serialVersionUID = 1L;
    public ClassOption stableLearnerOption = new ClassOption("stableLearner", 's', "Stable learner", Classifier.class, "bayes.NaiveBayes");
    public ClassOption reactiveLearnerOption = new ClassOption("reactiveLearner", 'r', "Reactive learner", Classifier.class, "bayes.NaiveBayes");
    public IntOption windowSizeOption = new IntOption("windowSize", 'w', "Window size for the reactive learner", 12, 1, Integer.MAX_VALUE);
    public FloatOption thresholdOption = new FloatOption("threshold", 't', "Threashold for creating a new stable learner", 0.2, 0.0, 1.0);
    protected int[] c;
    protected Classifier stableLearner;
    protected Classifier reactiveLearner;
    protected int t;
    protected int w;
    protected int theta;
    protected Instance[] instances;
    protected int changeDetected = 0;
    protected int numberOfErrors = 0;
    protected int i;

    @Override
    public void resetLearningImpl() {
        this.t = 0;
        this.w = this.windowSizeOption.getValue();
        this.c = new int[this.w];
        this.theta = (int)((double)this.w * this.thresholdOption.getValue());
        this.instances = new Instance[this.w];
        this.stableLearner = ((Classifier)this.getPreparedClassOption(this.stableLearnerOption)).copy();
        this.stableLearner.resetLearning();
        this.reactiveLearner = ((Classifier)this.getPreparedClassOption(this.reactiveLearnerOption)).copy();
        this.reactiveLearner.resetLearning();
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        this.instances[this.t] = inst;
        int trueClass = (int)inst.classValue();
        boolean stablePrediction = MiscUtils.maxIndex(this.stableLearner.getVotesForInstance(inst)) == trueClass;
        boolean reactivePrediction = MiscUtils.maxIndex(this.reactiveLearner.getVotesForInstance(inst)) == trueClass;
        this.numberOfErrors -= this.c[this.t];
        if (!stablePrediction && reactivePrediction) {
            this.c[this.t] = 1;
            ++this.numberOfErrors;
        } else {
            this.c[this.t] = 0;
        }
        if (this.theta < this.numberOfErrors) {
            ++this.changeDetected;
            this.stableLearner = this.reactiveLearner.copy();
            Arrays.fill(this.c, 0);
            this.numberOfErrors = 0;
        }
        this.stableLearner.trainOnInstance(inst);
        this.reactiveLearner.resetLearning();
        this.i = 0;
        while (this.i < this.instances.length && this.instances[this.i] != null) {
            this.reactiveLearner.trainOnInstance(this.instances[this.i]);
            ++this.i;
        }
        this.t = (this.t + 1) % this.w;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        return this.stableLearner.getVotesForInstance(inst);
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        LinkedList<Measurement> measurementList = new LinkedList<Measurement>();
        measurementList.add(new Measurement("Change detected", this.changeDetected));
        Measurement[] modelMeasurements = ((AbstractClassifier)this.stableLearner).getModelMeasurements();
        if (modelMeasurements != null) {
            measurementList.addAll(Arrays.asList(modelMeasurements));
        }
        this.changeDetected = 0;
        return measurementList.toArray(new Measurement[measurementList.size()]);
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }
}

