\name{ffnet summaries}
\title{Accessing Trained Single--Hidden--Layer Neural Networks}
\usage{
coef (nn)
fitted (nn)
plot (nn, colored = TRUE)
print (nn)
residuals (nn)
summary (nn, invert.type = c("svd", "qr", "chol"), \dots)

print (obj, digits = max(3,.Options$digits-3),
       signif.stars = .Options$show.signif.stars, \dots)
}
\alias{coef.ffnet}
\alias{fitted.ffnet}
\alias{plot.ffnet}
\alias{print.ffnet}
\alias{residuals.ffnet}
\alias{summary.ffnet}
\alias{print.summary.ffnet}
\arguments{
  \item{nn}{an object of class \code{ffnet}, usually, a result of
    \code{\link{ffnet}(.)}.}
  \item{colored}{a logical indicating whether for fitted factors colors
    or symbols are used to produce the plot.}
  \item{invert.type}{method to obtain the inverse Hessian. It must be
    one of \code{"svd"} (the default), \code{"qr"}, or \code{"chol"}.}
  \item{obj}{an object of class \code{summary.ffnet}.}
  \item{digits, signif.stars}{see \code{\link{print.coefmat}}.}
  \item{\ldots}{additional arguments to \code{\link{solve}} in
    \code{summary.ffnet} and to \code{\link{print}} and
    \code{\link{print.coefmat}} in \code{print.summary.ffnet}.}
}
\description{
  All these functions are \code{\link{methods}} for class
  \code{"ffnet"} or \code{"summary.ffnet"} objects.
}
\details{
  The generic accessor functions \code{coef.ffnet},
  \code{fitted.ffnet}, and \code{residuals.ffnet} can be used to extract
  various useful informations of an object of class \code{"ffnet"},
  usually a result of \code{\link{ffnet}}.

  \code{plot.ffnet} produces two plots. For nonfactor targets the
  observations against the fitted values and the absolute residuals
  against the fitted values are plotted. For factors the inputs are
  plotted and colored (coded) according to the fitted classification and
  the classification error.
  
  \code{print.ffnet} prints information about the call and the
  architecture of an object of class \code{"ffnet"}.
  
  \code{print.summary.ffnet} provides formatted output of an
  object of class \code{"summary.ffnet"}, usually a result of
  \code{summary.ffnet}. The output concerns the generating call,
  architecture, residuals, goodness-of-fit measures, model selection
  criteria, and weights (coefficients) of an object of class
  \code{"ffnet"}.

  \code{summary.ffnet} computes several summary statistics of the fitted
  model given by \code{nn}. Output are information concerning the
  generating call of the basic object of class \code{"ffnet"} and of its
  architecture. Furthermore, \code{residuals}, \code{coef},
  appropriate Goodness-of-Fit measures, model selection criteria, and
  coefficients statistics are computed. For nonfactor targets the
  Goodness-of-Fit measures are the R-squared statistics
  \code{r.squared.1} and \code{r.squared.2} for each output unit. The
  former is computed as the regression sum of squares divided by the
  total sum of squares SSR/SST. The latter is 1-SSE/SST, where SSE is
  the error sum of squares. For factors instead the confusion matrix of
  fitted values and target observations is computed. Model selection
  criteria are Akaike's and Schwarz's Information Criterion. Note
  that they are not appropriate to select the number of hidden units.
  Use instead \code{\link{ffnet.terasvirta.test}}. The coefficients
  statistics, i.e., the (asymptotic) standard errors, t-statistics and
  corresponding (two-sided) p-values, are obtained from the asymptotic normal
  distribution. The covariance matrix is computed from the
  Hessian \code{\link{hessian.ffnet}}. Note, that these statistics are
  only valid under appropriate regularity assumptions for the estimation
  problem of the neural network model (c.f. references). These
  statistics cannot be used to test the irrelevance of a given hidden
  unit and, hence, to select the number of hidden units.  

  \code{summary.ffnet} has a side effect: If \code{summary.ffnet} is
  called and the Hessian of the incoming argument \code{nn} has not yet
  been computed, then \code{summary.ffnet} computes the Hessian
  by calling \code{\link{hessian.ffnet}} and assigns it to the
  \code{hessian} component of the incoming argument
  \code{nn}. Therefore, the incoming argument must be a variable, e.g.,
  \code{summary (nn <- ffnet (y~x))} or \code{summary (nn)} are allowed,
  \code{summary (ffnet (y~x))}, however, is not allowed.
}
\value{
  \code{coef.ffnet}, \code{fitted.ffnet}, and \code{residuals.ffnet}
  return the formatted coefficients, fitted values and residuals of an object of
  class \code{"ffnet"}.
  
  \code{plot} and \code{print} return the input object.
  
  \code{summary.ffnet} returns a list of summary statistics of the
  fitted model given by \code{nn}. The returned object is of class
  \code{"summary.ffnet"}. 
  
  \code{print.summary.ffnet} returns the incoming object of class
  \code{"summary.ffnet"}. 
}
\seealso{
  \code{\link{predict.ffnet}}, \code{\link{hessian.ffnet}},
  \code{\link{ffnet}}
}
\references{
  C.M. Bishop (1995): \emph{Neural Networks for Pattern
  Recognition}, Clarendon Press, Oxford.
  
  R. Davidson and J.G. MacKinnon (1993): \emph{Estimation and Inference
  in Econometrics}, Oxford University Press, NY.
       
  A. Trapletti (1999): FFNET: A Fast and Flexible software
  library for single-hidden-layer neural NETworks, unpublished
  report.

  H. White (1996): Parametric Statistical Estimation with Artificial Neural
  Networks, in P. Smolensky M.C. Mozer, and D.E. Rumelhart:
  \emph{Mathematical Perspectives on Neural Networks}, Lawrence Erlbaum
  Associates, Mahwah, New Jersey.
}
\author{A. Trapletti}
\examples{
x <- runif (1000, -1, 1)  # Non-linear Regression
y <- x^2 - x^3 +0.1*rnorm(x)
plot (x, y)
rr <- lm (y~x)
summary (rr)
points (x, predict(rr,x), col="red")
nn <- ffnet (y~x, nhid=1, itmax=100, optim="DFPMIN", shortcut=T)
summary (nn)
points (x, predict(nn,x), col="green")
}
\keyword{nonlinear, neural}

